/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CountSqlAggregation
extends SqlAggregation {
    private long value;

    public CountSqlAggregation() {
        super(-1, false, false);
    }

    public CountSqlAggregation(int index) {
        super(index, true, false);
    }

    public CountSqlAggregation(int index, boolean distinct) {
        super(index, true, distinct);
    }

    @Override
    public QueryDataType resultType() {
        return QueryDataType.BIGINT;
    }

    @Override
    protected void accumulate(Object value) {
        ++this.value;
    }

    @Override
    public void combine(SqlAggregation other0) {
        CountSqlAggregation other = (CountSqlAggregation)other0;
        this.value += other.value;
    }

    @Override
    public Object collect() {
        return this.value;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.value = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountSqlAggregation that = (CountSqlAggregation)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

