/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.Mapping;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.Permission;
import java.util.List;

interface JetPlan
extends SqlPlan {
    public SqlResult execute();

    public static class ShowStatementPlan
    implements JetPlan {
        private final SqlShowStatement.ShowStatementTarget showTarget;
        private final JetPlanExecutor planExecutor;

        ShowStatementPlan(SqlShowStatement.ShowStatementTarget showTarget, JetPlanExecutor planExecutor) {
            this.showTarget = showTarget;
            this.planExecutor = planExecutor;
        }

        public SqlShowStatement.ShowStatementTarget getShowTarget() {
            return this.showTarget;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }
    }

    public static class SelectOrSinkPlan
    implements JetPlan {
        private final DAG dag;
        private final boolean isStreaming;
        private final boolean isInsert;
        private final QueryId queryId;
        private final SqlRowMetadata rowMetadata;
        private final JetPlanExecutor planExecutor;
        private final List<Permission> permissions;

        SelectOrSinkPlan(DAG dag, boolean isStreaming, boolean isInsert, QueryId queryId, SqlRowMetadata rowMetadata, JetPlanExecutor planExecutor, List<Permission> permissions) {
            this.dag = dag;
            this.isStreaming = isStreaming;
            this.isInsert = isInsert;
            this.queryId = queryId;
            this.rowMetadata = rowMetadata;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
            for (Permission permission : this.permissions) {
                context.checkPermission(permission);
            }
        }

        DAG getDag() {
            return this.dag;
        }

        boolean isStreaming() {
            return this.isStreaming;
        }

        boolean isInsert() {
            return this.isInsert;
        }

        QueryId getQueryId() {
            return this.queryId;
        }

        SqlRowMetadata getRowMetadata() {
            return this.rowMetadata;
        }
    }

    public static class DropSnapshotPlan
    implements JetPlan {
        private final String snapshotName;
        private final boolean ifExists;
        private final JetPlanExecutor planExecutor;

        DropSnapshotPlan(String snapshotName, boolean ifExists, JetPlanExecutor planExecutor) {
            this.snapshotName = snapshotName;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public boolean isIfExists() {
            return this.ifExists;
        }
    }

    public static class CreateSnapshotPlan
    implements JetPlan {
        private final String snapshotName;
        private final String jobName;
        private final JetPlanExecutor planExecutor;

        CreateSnapshotPlan(String snapshotName, String jobName, JetPlanExecutor planExecutor) {
            this.snapshotName = snapshotName;
            this.jobName = jobName;
            this.planExecutor = planExecutor;
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public String getJobName() {
            return this.jobName;
        }
    }

    public static class DropJobPlan
    implements JetPlan {
        private final String jobName;
        private final boolean ifExists;
        private final String withSnapshotName;
        private final JetPlanExecutor planExecutor;

        DropJobPlan(String jobName, boolean ifExists, String withSnapshotName, JetPlanExecutor planExecutor) {
            this.jobName = jobName;
            this.ifExists = ifExists;
            this.withSnapshotName = withSnapshotName;
            this.planExecutor = planExecutor;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        public String getJobName() {
            return this.jobName;
        }

        public boolean isIfExists() {
            return this.ifExists;
        }

        public String getWithSnapshotName() {
            return this.withSnapshotName;
        }
    }

    public static class AlterJobPlan
    implements JetPlan {
        private final String jobName;
        private final SqlAlterJob.AlterJobOperation operation;
        private final JetPlanExecutor planExecutor;

        AlterJobPlan(String jobName, SqlAlterJob.AlterJobOperation operation, JetPlanExecutor planExecutor) {
            this.jobName = jobName;
            this.operation = operation;
            this.planExecutor = planExecutor;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        public String getJobName() {
            return this.jobName;
        }

        public SqlAlterJob.AlterJobOperation getOperation() {
            return this.operation;
        }
    }

    public static class CreateJobPlan
    implements JetPlan {
        private final String jobName;
        private final JobConfig jobConfig;
        private final boolean ifNotExists;
        private final SelectOrSinkPlan dmlPlan;
        private final JetPlanExecutor planExecutor;

        CreateJobPlan(String jobName, JobConfig jobConfig, boolean ifNotExists, SelectOrSinkPlan dmlPlan, JetPlanExecutor planExecutor) {
            this.jobName = jobName;
            this.jobConfig = jobConfig;
            this.ifNotExists = ifNotExists;
            this.dmlPlan = dmlPlan;
            this.planExecutor = planExecutor;
        }

        public void checkPermissions(SqlSecurityContext context) {
            this.dmlPlan.checkPermissions(context);
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public String getJobName() {
            return this.jobName;
        }

        public JobConfig getJobConfig() {
            return this.jobConfig;
        }

        public boolean isIfNotExists() {
            return this.ifNotExists;
        }

        public SelectOrSinkPlan getExecutionPlan() {
            return this.dmlPlan;
        }
    }

    public static class DropMappingPlan
    implements JetPlan {
        private final String name;
        private final boolean ifExists;
        private final JetPlanExecutor planExecutor;

        DropMappingPlan(String name, boolean ifExists, JetPlanExecutor planExecutor) {
            this.name = name;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        String name() {
            return this.name;
        }

        boolean ifExists() {
            return this.ifExists;
        }
    }

    public static class CreateMappingPlan
    implements JetPlan {
        private final Mapping mapping;
        private final boolean replace;
        private final boolean ifNotExists;
        private final JetPlanExecutor planExecutor;

        CreateMappingPlan(Mapping mapping, boolean replace, boolean ifNotExists, JetPlanExecutor planExecutor) {
            this.mapping = mapping;
            this.replace = replace;
            this.ifNotExists = ifNotExists;
            this.planExecutor = planExecutor;
        }

        @Override
        public SqlResult execute() {
            return this.planExecutor.execute(this);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        Mapping mapping() {
            return this.mapping;
        }

        boolean replace() {
            return this.replace;
        }

        boolean ifNotExists() {
            return this.ifNotExists;
        }
    }
}

