/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.python;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.test.GeneratorFunction;
import com.hazelcast.jet.pipeline.test.TestSources;
import com.hazelcast.jet.python.PythonServiceConfig;
import com.hazelcast.jet.python.PythonTransforms;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;

public class Python {
    private static final String RESULTS = "python_results";

    private static Pipeline buildPipeline(String baseDir) {
        Pipeline p = Pipeline.create();
        p.readFrom(TestSources.itemStream((int)10, (GeneratorFunction & Serializable)(ts, seq) -> Python.bigRandomNumberAsString())).withoutTimestamps().apply(PythonTransforms.mapUsingPython((PythonServiceConfig)new PythonServiceConfig().setBaseDir(baseDir).setHandlerModule("take_sqrt"))).setLocalParallelism(1).writeTo(Sinks.observable((String)RESULTS));
        return p;
    }

    private static String bigRandomNumberAsString() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        return "" + rnd.nextLong(Long.MAX_VALUE) + rnd.nextLong(Long.MAX_VALUE) + rnd.nextLong(Long.MAX_VALUE) + rnd.nextLong(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Path baseDir = Util.getFilePathOfClasspathResource((String)"python");
        Pipeline p = Python.buildPipeline(baseDir.toString());
        JetInstance jet = Jet.bootstrappedInstance();
        try {
            Observable observable = jet.getObservable(RESULTS);
            observable.addObserver(System.out::println);
            JobConfig config = new JobConfig().setName("python-mapping");
            jet.newJobIfAbsent(p, config).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

