/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.protobuf;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.test.TestSources;
import com.hazelcast.jet.protobuf.Messages;
import com.hazelcast.jet.protobuf.ProtobufSerializerHook;
import java.io.Serializable;

public class ProtobufSerializerHookAdapter {
    private static final String LIST_NAME = "products";
    private JetInstance jet;

    public static void main(String[] args) {
        new ProtobufSerializerHookAdapter().go();
    }

    private void go() {
        try {
            this.setup();
            this.jet.newJob(ProtobufSerializerHookAdapter.buildPipeline()).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private void setup() {
        this.jet = Jet.bootstrappedInstance();
    }

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.readFrom(TestSources.items((Object[])new String[]{"jam", "marmalade"})).map((FunctionEx & Serializable)name -> Messages.Product.newBuilder().setName((String)name).build()).writeTo(Sinks.list((String)LIST_NAME));
        return p;
    }

    private static class ProductSerializerHook
    extends ProtobufSerializerHook<Messages.Product> {
        private static final int TYPE_ID = 17;

        ProductSerializerHook() {
            super(Messages.Product.class, 17);
        }
    }
}

