/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.jms;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;

public final class JmsMessageProducer {
    private final Thread producerThread = new Thread(() -> {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = null;
        try {
            try {
                connection = connectionFactory.createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                Object destination = destinationType == DestinationType.QUEUE ? session.createQueue(destinationName) : session.createTopic(destinationName);
                MessageProducer producer = session.createProducer((Destination)destination);
                int count = 0;
                while (true) {
                    TextMessage textMessage = session.createTextMessage("Message-" + count++);
                    producer.send((Message)textMessage);
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (JMSException e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                if (connection != null) {
                    Util.uncheckRun(() -> ((Connection)connection).close());
                }
            }
        }
        catch (Throwable throwable) {
            if (connection != null) {
                Util.uncheckRun(() -> ((Connection)connection).close());
            }
            throw throwable;
        }
    });

    JmsMessageProducer(String destinationName, DestinationType destinationType) {
    }

    public void start() {
        this.producerThread.start();
    }

    public void stop() {
        try {
            this.producerThread.interrupt();
            this.producerThread.join();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    static enum DestinationType {
        QUEUE,
        TOPIC;

    }
}

