/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.examples.jdbc.User;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.DeleteDbFiles;

public class JdbcSource {
    private static final String MAP_NAME = "userMap";
    private static final String TABLE_NAME = "USER_TABLE";
    private JetInstance jet;
    private String dbDirectory;

    private static Pipeline buildPipeline(String connectionUrl) {
        Pipeline p = Pipeline.create();
        p.readFrom(Sources.jdbc((String)connectionUrl, (String)"SELECT * FROM USER_TABLE", (FunctionEx & Serializable)resultSet -> new User(resultSet.getInt(1), resultSet.getString(2)))).map((FunctionEx & Serializable)user -> Util.entry((Object)user.getId(), (Object)user)).writeTo(Sinks.map((String)MAP_NAME));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new JdbcSource().go();
    }

    private void go() throws Exception {
        try {
            this.setup();
            Pipeline p = JdbcSource.buildPipeline(this.connectionUrl());
            this.jet.newJob(p).join();
            this.jet.getMap(MAP_NAME).values().forEach(System.out::println);
        }
        finally {
            this.cleanup();
        }
    }

    private void setup() throws Exception {
        this.dbDirectory = Files.createTempDirectory(JdbcSource.class.getName(), new FileAttribute[0]).toString();
        this.createAndFillTable();
        this.jet = Jet.bootstrappedInstance();
    }

    private void cleanup() {
        Jet.shutdownAll();
        DeleteDbFiles.execute((String)this.dbDirectory, (String)JdbcSource.class.getSimpleName(), (boolean)true);
    }

    private void createAndFillTable() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl());
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE USER_TABLE(id int primary key, name varchar(255))");
            try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO USER_TABLE(id, name) VALUES(?, ?)");){
                for (int i = 0; i < 100; ++i) {
                    stmt.setInt(1, i);
                    stmt.setString(2, "name-" + i);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
        }
    }

    private String connectionUrl() {
        return "jdbc:h2:" + this.dbDirectory + "/" + JdbcSource.class.getSimpleName();
    }
}

