/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.helloworld;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.function.Observer;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.WindowDefinition;
import com.hazelcast.jet.pipeline.test.GeneratorFunction;
import com.hazelcast.jet.pipeline.test.TestSources;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class HelloWorld {
    public static final int TOP = 10;
    private static final String RESULTS = "top10_results";

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.readFrom(TestSources.itemStream((int)100, (GeneratorFunction & Serializable)(ts, seq) -> HelloWorld.nextRandomNumber())).withIngestionTimestamps().window((WindowDefinition)WindowDefinition.tumbling((long)1000L)).aggregate(AggregateOperations.topN((int)10, (ComparatorEx)ComparatorEx.comparingLong((ToLongFunctionEx & Serializable)l -> l))).map(WindowResult::result).writeTo(Sinks.observable((String)RESULTS));
        return p;
    }

    private static long nextRandomNumber() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static void main(String[] args) {
        JetInstance jet = Jet.bootstrappedInstance();
        Observable observable = jet.getObservable(RESULTS);
        observable.addObserver(Observer.of(HelloWorld::printResults));
        Pipeline p = HelloWorld.buildPipeline();
        JobConfig config = new JobConfig();
        config.setName("hello-world");
        config.setProcessingGuarantee(ProcessingGuarantee.EXACTLY_ONCE);
        jet.newJobIfAbsent(p, config).join();
    }

    private static void printResults(List<Long> topNumbers) {
        StringBuilder sb = new StringBuilder(String.format("\nTop %d random numbers in the latest window: ", 10));
        for (int i = 0; i < topNumbers.size(); ++i) {
            sb.append(String.format("\n\t%d. %,d", i + 1, topNumbers.get(i)));
        }
        System.out.println(sb.toString());
    }
}

