/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.grpc;

import com.hazelcast.jet.examples.grpc.datamodel.Trade;
import com.hazelcast.map.IMap;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class EventGenerator
extends Thread {
    private static final int PRODUCT_ID_BASE = 31;
    private static final int BROKER_ID_BASE = 21;
    private static final int PRODUCT_BROKER_COUNT = 4;
    private volatile boolean enabled;
    private volatile boolean keepRunning = true;
    private final IMap<Object, Trade> trades;

    EventGenerator(IMap<Object, Trade> trades) {
        this.trades = trades;
    }

    @Override
    public void run() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int tradeId = 1;
        while (this.keepRunning) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            if (!this.enabled) continue;
            Trade trad = new Trade(tradeId, 31 + ((Random)rnd).nextInt(4), 21 + ((Random)rnd).nextInt(4));
            this.trades.put((Object)42, (Object)trad);
            ++tradeId;
        }
    }

    void generateEventsForFiveSeconds() throws InterruptedException {
        this.enabled = true;
        System.out.println("\nGenerating trade events\n");
        Thread.sleep(5000L);
        System.out.println("\nStopped trade events\n");
        this.enabled = false;
    }

    void shutdown() {
        this.keepRunning = false;
    }
}

