/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;

public class SalesJsonAnalyzer {
    private static Pipeline buildPipeline(String sourceDir) {
        Pipeline p = Pipeline.create();
        BatchSource source = Sources.json((String)sourceDir, SalesRecord.class);
        p.readFrom(source).filter((PredicateEx & Serializable)record -> record.price < 30.0).groupingKey((FunctionEx & Serializable)r -> r.paymentType).aggregate(AggregateOperations.counting()).writeTo(Sinks.logger());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage:");
            System.err.println("  " + SalesJsonAnalyzer.class.getSimpleName() + " <sourceDir>");
            System.exit(1);
        }
        String sourceDir = args[0];
        Pipeline p = SalesJsonAnalyzer.buildPipeline(sourceDir);
        JetInstance instance = Jet.bootstrappedInstance();
        try {
            instance.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static class SalesRecord
    implements Serializable {
        @JsonProperty(value="payment_type")
        public String paymentType;
        public long time;
        public String product;
        public double price;
        public String name;
        public String address;
        public String city;
        public String state;
        public String country;

        private SalesRecord() {
        }

        public String toString() {
            return "SalesRecord{time=" + this.time + ", product='" + this.product + '\'' + ", price=" + this.price + ", paymentType='" + this.paymentType + '\'' + ", name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + '}';
        }
    }
}

