/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class SalesCsvAnalyzer {
    private static Pipeline buildPipeline(String sourceDir) {
        Pipeline p = Pipeline.create();
        BatchSource source = Sources.filesBuilder((String)sourceDir).glob("*.csv").build((FunctionEx & Serializable)path -> Files.lines(path).skip(1L).map(SalesRecordLine::parse));
        p.readFrom(source).filter((PredicateEx & Serializable)record -> record.getPrice() < 30.0).groupingKey(SalesRecordLine::getPaymentType).aggregate(AggregateOperations.counting()).writeTo(Sinks.logger());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage:");
            System.err.println("  " + SalesCsvAnalyzer.class.getSimpleName() + " <sourceDir>");
            System.exit(1);
        }
        String sourceDir = args[0];
        Pipeline p = SalesCsvAnalyzer.buildPipeline(sourceDir);
        JetInstance instance = Jet.bootstrappedInstance();
        try {
            instance.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static class SalesRecordLine
    implements Serializable {
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.US);
        private long time;
        private String product;
        private double price;
        private String paymentType;
        private String name;
        private String city;
        private String state;
        private String country;

        private SalesRecordLine() {
        }

        public static SalesRecordLine parse(String line) {
            String[] split = line.split(",");
            SalesRecordLine record = new SalesRecordLine();
            record.time = LocalDateTime.parse(split[0], DATE_TIME_FORMATTER).toInstant(ZoneOffset.UTC).toEpochMilli();
            record.product = split[1];
            record.price = Double.parseDouble(split[2]);
            record.paymentType = split[3];
            record.name = split[4];
            record.city = split[5];
            record.state = split[6];
            record.country = split[7];
            return record;
        }

        public long getTime() {
            return this.time;
        }

        public String getProduct() {
            return this.product;
        }

        public double getPrice() {
            return this.price;
        }

        public String getPaymentType() {
            return this.paymentType;
        }

        public String getName() {
            return this.name;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public String toString() {
            return "SalesRecordLine{time=" + this.time + ", product='" + this.product + '\'' + ", price=" + this.price + ", paymentType='" + this.paymentType + '\'' + ", name='" + this.name + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + '}';
        }
    }
}

