/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.eventjournal;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.jet.ICacheJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CacheJournalSource {
    private static final String CACHE_NAME = "cache";
    private static final String SINK_NAME = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetConfig jetConfig = CacheJournalSource.getJetConfig();
        JetInstance jet = Jet.newJetInstance((JetConfig)jetConfig);
        Jet.newJetInstance((JetConfig)jetConfig);
        try {
            Pipeline p = Pipeline.create();
            p.drawFrom(Sources.cacheJournal((String)CACHE_NAME, (JournalInitialPosition)JournalInitialPosition.START_FROM_OLDEST)).withoutTimestamps().map(Map.Entry::getValue).drainTo(Sinks.list((String)SINK_NAME));
            jet.newJob(p);
            ICacheJet cache = jet.getCacheManager().getCache(CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                cache.put((Object)i, (Object)i);
            }
            TimeUnit.SECONDS.sleep(3L);
            System.out.println("Read " + jet.getList(SINK_NAME).size() + " entries from cache journal.");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static JetConfig getJetConfig() {
        JetConfig cfg = new JetConfig();
        cfg.getHazelcastConfig().addCacheConfig(new CacheSimpleConfig().setName(CACHE_NAME));
        cfg.getHazelcastConfig().getCacheEventJournalConfig(CACHE_NAME).setEnabled(true).setCapacity(1000).setTimeToLiveSeconds(10);
        return cfg;
    }
}

