/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.eventjournal;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.nio.Address;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RemoteCacheJournalSource {
    private static final String CACHE_NAME = "cache";
    private static final String SINK_NAME = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        Config hzConfig = RemoteCacheJournalSource.getConfig();
        HazelcastInstance remoteHz = RemoteCacheJournalSource.startRemoteHzCluster(hzConfig);
        JetInstance localJet = RemoteCacheJournalSource.startLocalJetCluster();
        try {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.getNetworkConfig().addAddress(new String[]{RemoteCacheJournalSource.getAddress(remoteHz)});
            clientConfig.setGroupConfig(hzConfig.getGroupConfig());
            Pipeline p = Pipeline.create();
            p.drawFrom(Sources.remoteCacheJournal((String)CACHE_NAME, (ClientConfig)clientConfig, (JournalInitialPosition)JournalInitialPosition.START_FROM_OLDEST)).withoutTimestamps().map(Map.Entry::getValue).drainTo(Sinks.list((String)SINK_NAME));
            localJet.newJob(p);
            ICache cache = remoteHz.getCacheManager().getCache(CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                cache.put((Object)i, (Object)i);
            }
            TimeUnit.SECONDS.sleep(3L);
            System.out.println("Read " + localJet.getList(SINK_NAME).size() + " entries from remote cache journal.");
        }
        finally {
            Hazelcast.shutdownAll();
            Jet.shutdownAll();
        }
    }

    private static String getAddress(HazelcastInstance remoteHz) {
        Address address = remoteHz.getCluster().getLocalMember().getAddress();
        return address.getHost() + ":" + address.getPort();
    }

    private static JetInstance startLocalJetCluster() {
        JetInstance localJet = Jet.newJetInstance();
        Jet.newJetInstance();
        return localJet;
    }

    private static HazelcastInstance startRemoteHzCluster(Config config) {
        HazelcastInstance remoteHz = Hazelcast.newHazelcastInstance((Config)config);
        Hazelcast.newHazelcastInstance((Config)config);
        return remoteHz;
    }

    private static Config getConfig() {
        Config config = new Config();
        config.addCacheConfig(new CacheSimpleConfig().setName(CACHE_NAME));
        config.addEventJournalConfig(new EventJournalConfig().setEnabled(true).setCacheName(CACHE_NAME).setCapacity(1000).setTimeToLiveSeconds(10));
        return config;
    }
}

