/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.elastic;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.elastic.ElasticClients;
import com.hazelcast.jet.elastic.ElasticSinks;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.elasticsearch.action.index.IndexRequest;

public class ElasticSinkExample {
    public static void main(String[] args) {
        try {
            Pipeline p = Pipeline.create();
            p.readFrom(ElasticSinkExample.files("src/main/resources/documents")).map(JsonUtil::mapFrom).writeTo(ElasticSinks.elastic((SupplierEx & Serializable)() -> ElasticClients.client((String)"localhost", (int)9200), (FunctionEx & Serializable)map -> new IndexRequest("my-index").source(map)));
            JetInstance jet = Jet.bootstrappedInstance();
            jet.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    public static BatchSource<String> files(String directory) {
        return Sources.filesBuilder((String)directory).build((FunctionEx & Serializable)path -> Stream.of(new String(Files.readAllBytes(path), StandardCharsets.UTF_8)));
    }
}

