/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.manager.impl;

import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.tasks.test.TestObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ghprb.manager.GhprbBuildManager;
import org.jenkinsci.plugins.ghprb.manager.configuration.JobConfiguration;

public abstract class GhprbBaseBuildManager
implements GhprbBuildManager {
    private static final Logger LOGGER = Logger.getLogger(GhprbBaseBuildManager.class.getName());
    protected Run<?, ?> build;
    private static final int MAX_LINES_COUNT = 25;
    private JobConfiguration jobConfiguration;

    public GhprbBaseBuildManager(Run<?, ?> build) {
        this.build = build;
        this.jobConfiguration = this.buildDefaultConfiguration();
    }

    public GhprbBaseBuildManager(Run<?, ?> build, JobConfiguration jobConfiguration) {
        this.build = build;
        this.jobConfiguration = jobConfiguration;
    }

    private JobConfiguration buildDefaultConfiguration() {
        return JobConfiguration.builder().printStackTrace(false).build();
    }

    @Override
    public String calculateBuildUrl(String publishedURL) {
        return publishedURL + "/" + this.build.getUrl();
    }

    @Override
    public Iterator<?> downstreamProjects() {
        ArrayList downstreamList = new ArrayList();
        downstreamList.add(this.build);
        return downstreamList.iterator();
    }

    public JobConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }

    @Override
    public String getTestResults() {
        return this.getAggregatedTestResults(this.build);
    }

    protected String getAggregatedTestResults(Run<?, ?> build) {
        AggregatedTestResultAction testResultAction = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class);
        if (testResultAction == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Result buildResult = build.getResult();
        if (buildResult != null && buildResult != Result.UNSTABLE) {
            sb.append("<h2>Build result: ");
            sb.append(buildResult.toString());
            sb.append("</span></h2>");
            try {
                List buildLog = build.getLog(25);
                for (String buildLogLine : buildLog) {
                    sb.append(buildLogLine);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, ioe.getMessage());
            }
            return sb.toString();
        }
        sb.append("<h2>Failed Tests: ");
        sb.append("<span class='status-failure'>");
        sb.append(testResultAction.getFailCount());
        sb.append("</span></h2>");
        List childReports = testResultAction.getChildReports();
        for (AggregatedTestResultAction.ChildReport report : childReports) {
            TestResult result = (TestResult)report.result;
            if (result.getFailCount() < 1) continue;
            AbstractProject project = report.child.getProject();
            String baseUrl = Jenkins.getInstance().getRootUrl() + build.getUrl() + project.getShortUrl() + "testReport";
            sb.append("<h3>");
            sb.append("<a name='");
            sb.append(project.getFullName());
            sb.append("' />");
            sb.append("<a href='");
            sb.append(baseUrl);
            sb.append("'>");
            sb.append(project.getFullName());
            sb.append("</a>");
            sb.append(": ");
            sb.append("<span class='status-failure'>");
            sb.append(result.getFailCount());
            sb.append("</span></h3>");
            sb.append("<ul>");
            List failedTests = result.getFailedTests();
            for (CaseResult failedTest : failedTests) {
                sb.append("<li>");
                sb.append("<a href='");
                sb.append(baseUrl);
                sb.append("/");
                sb.append(failedTest.getRelativePathFrom((TestObject)result));
                sb.append("'>");
                sb.append("<strong>");
                sb.append(failedTest.getFullDisplayName());
                sb.append("</strong>");
                sb.append("</a>");
                if (this.getJobConfiguration().printStackTrace()) {
                    sb.append("\n```\n");
                    sb.append(failedTest.getErrorStackTrace());
                    sb.append("\n```\n");
                }
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    @Override
    public String getOneLineTestResults() {
        AbstractTestResultAction testResultAction = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
        if (testResultAction == null) {
            return "No test results found.";
        }
        return String.format("%d tests run, %d skipped, %d failed.", testResultAction.getTotalCount(), testResultAction.getSkipCount(), testResultAction.getFailCount());
    }
}

