/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.extensions.status;

import hudson.Extension;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatus;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatusException;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtensionDescriptor;
import org.jenkinsci.plugins.ghprb.extensions.GhprbGlobalDefault;
import org.jenkinsci.plugins.ghprb.extensions.GhprbGlobalExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbProjectExtension;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildResultMessage;
import org.jenkinsci.plugins.ghprb.manager.GhprbBuildManager;
import org.jenkinsci.plugins.ghprb.manager.configuration.JobConfiguration;
import org.jenkinsci.plugins.ghprb.manager.factory.GhprbBuildManagerFactoryUtil;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;

public class GhprbSimpleStatus
extends GhprbExtension
implements GhprbCommitStatus,
GhprbGlobalExtension,
GhprbProjectExtension,
GhprbGlobalDefault {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String commitStatusContext;
    private final Boolean showMatrixStatus;
    private final String triggeredStatus;
    private final String startedStatus;
    private final String statusUrl;
    private final Boolean addTestResults;
    private final List<GhprbBuildResultMessage> completedStatus;

    public GhprbSimpleStatus() {
        this(null);
    }

    public GhprbSimpleStatus(String commitStatusContext) {
        this(false, commitStatusContext, null, null, null, false, new ArrayList<GhprbBuildResultMessage>(0));
    }

    @DataBoundConstructor
    public GhprbSimpleStatus(Boolean showMatrixStatus, String commitStatusContext, String statusUrl, String triggeredStatus, String startedStatus, Boolean addTestResults, List<GhprbBuildResultMessage> completedStatus) {
        this.showMatrixStatus = showMatrixStatus;
        this.statusUrl = statusUrl;
        this.commitStatusContext = commitStatusContext == null ? "" : commitStatusContext;
        this.triggeredStatus = triggeredStatus;
        this.startedStatus = startedStatus;
        this.addTestResults = addTestResults;
        this.completedStatus = completedStatus;
    }

    public String getStatusUrl() {
        return this.statusUrl == null ? "" : this.statusUrl;
    }

    public boolean getShowMatrixStatus() {
        return this.showMatrixStatus == null ? false : this.showMatrixStatus;
    }

    public String getCommitStatusContext() {
        return this.commitStatusContext == null ? "" : this.commitStatusContext;
    }

    public String getStartedStatus() {
        return this.startedStatus == null ? "" : this.startedStatus;
    }

    public String getTriggeredStatus() {
        return this.triggeredStatus == null ? "" : this.triggeredStatus;
    }

    public Boolean getAddTestResults() {
        return this.addTestResults == null ? Boolean.valueOf(false) : this.addTestResults;
    }

    public List<GhprbBuildResultMessage> getCompletedStatus() {
        return this.completedStatus == null ? new ArrayList(0) : this.completedStatus;
    }

    public boolean addIfMissing() {
        return true;
    }

    @Override
    public void onBuildTriggered(Job<?, ?> project, String commitSha, boolean isMergeable, int prId, GHRepository ghRepository) throws GhprbCommitStatusException {
        StringBuilder sb = new StringBuilder();
        GHCommitState state = GHCommitState.PENDING;
        String triggeredStatus = this.getDescriptor().getTriggeredStatusDefault(this);
        if (StringUtils.equals((String)triggeredStatus, (String)"--none--")) {
            return;
        }
        String statusUrl = this.getDescriptor().getStatusUrlDefault(this);
        if ("".equals(this.commitStatusContext)) {
            this.commitStatusContext = this.getDescriptor().getCommitStatusContextDefault(this);
        }
        String context = Util.fixEmpty((String)this.commitStatusContext);
        context = Ghprb.replaceMacros(project, context);
        if (!StringUtils.isEmpty((String)triggeredStatus)) {
            sb.append(Ghprb.replaceMacros(project, triggeredStatus));
        } else {
            sb.append("Build triggered");
            if (isMergeable) {
                sb.append(" for merge commit.");
            } else {
                sb.append(" for original commit.");
            }
        }
        String url = Ghprb.replaceMacros(project, statusUrl);
        if (StringUtils.equals((String)statusUrl, (String)"--none--")) {
            url = "";
        }
        String message = sb.toString();
        try {
            ghRepository.createCommitStatus(commitSha, state, url, message, context);
        }
        catch (IOException e) {
            throw new GhprbCommitStatusException(e, state, message, prId);
        }
    }

    @Override
    public void onEnvironmentSetup(Run<?, ?> build, TaskListener listener, GHRepository repo) throws GhprbCommitStatusException {
    }

    @Override
    public void onBuildStart(Run<?, ?> build, TaskListener listener, GHRepository repo) throws GhprbCommitStatusException {
        String startedStatus = this.getDescriptor().getStartedStatusDefault(this);
        boolean showMatrixStatus = this.getDescriptor().getShowMatrixStatusDefault(this);
        if (showMatrixStatus && !(build.getParent() instanceof MatrixProject)) {
            return;
        }
        if (StringUtils.equals((String)startedStatus, (String)"--none--")) {
            return;
        }
        GhprbCause c = Ghprb.getCause(build);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)startedStatus)) {
            sb.append("Build started");
            if (c != null) {
                sb.append(c.isMerged() ? " for merge commit." : " for original commit.");
            }
        } else {
            sb.append(Ghprb.replaceMacros(build, listener, startedStatus));
        }
        this.createCommitStatus(build, listener, sb.toString(), repo, GHCommitState.PENDING);
    }

    @Override
    public void onBuildComplete(Run<?, ?> build, TaskListener listener, GHRepository repo) throws GhprbCommitStatusException {
        List<GhprbBuildResultMessage> completedStatus = this.getDescriptor().getCompletedStatusDefault(this);
        boolean showMatrixStatus = this.getDescriptor().getShowMatrixStatusDefault(this);
        if (showMatrixStatus && !(build.getParent() instanceof MatrixProject)) {
            return;
        }
        GHCommitState state = Ghprb.getState(build);
        StringBuilder sb = new StringBuilder();
        if (completedStatus == null || completedStatus.isEmpty()) {
            sb.append("Build finished.");
        } else {
            for (GhprbBuildResultMessage buildStatus : completedStatus) {
                sb.append(buildStatus.postBuildComment(build, listener));
            }
            if (StringUtils.equals((String)sb.toString(), (String)"--none--")) {
                return;
            }
        }
        sb.append(" ");
        GhprbTrigger trigger = Ghprb.extractTrigger(build);
        if (trigger == null) {
            listener.getLogger().println("Unable to get pull request builder trigger!!");
        } else {
            JobConfiguration jobConfiguration = JobConfiguration.builder().printStackTrace(trigger.getDisplayBuildErrorsOnDownstreamBuilds()).build();
            GhprbBuildManager buildManager = GhprbBuildManagerFactoryUtil.getBuildManager(build, jobConfiguration);
            if (this.getAddTestResults().booleanValue()) {
                listener.getLogger().println("Adding one-line test results to commit status...");
                sb.append(buildManager.getOneLineTestResults());
            }
        }
        this.createCommitStatus(build, listener, sb.toString(), repo, state);
    }

    private void createCommitStatus(Run<?, ?> build, TaskListener listener, String message, GHRepository repo, GHCommitState state) throws GhprbCommitStatusException {
        Map<String, String> envVars = Ghprb.getEnvVars(build, listener);
        String sha1 = envVars.get("ghprbActualCommit");
        Integer pullId = Integer.parseInt(envVars.get("ghprbPullId"));
        String url = envVars.get("BUILD_URL");
        if (StringUtils.isEmpty((String)url)) {
            url = envVars.get("JOB_URL");
        }
        if (StringUtils.isEmpty((String)url)) {
            url = Jenkins.getInstance().getRootUrl() + build.getUrl();
        }
        if (StringUtils.equals((String)this.statusUrl, (String)"--none--")) {
            url = "";
        } else if (!StringUtils.isEmpty((String)this.statusUrl)) {
            url = Ghprb.replaceMacros(build, listener, this.statusUrl);
        }
        String context = Util.fixEmpty((String)this.commitStatusContext);
        context = Ghprb.replaceMacros(build, listener, context);
        listener.getLogger().println(String.format("Setting status of %s to %s with url %s and message: '%s'", sha1, state, url, message));
        if (context != null) {
            listener.getLogger().println("Using context: " + context);
        }
        try {
            repo.createCommitStatus(sha1, state, url, message, context);
        }
        catch (IOException e) {
            throw new GhprbCommitStatusException(e, state, message, pullId);
        }
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends GhprbExtensionDescriptor
    implements GhprbGlobalExtension,
    GhprbProjectExtension {
        public String getDisplayName() {
            return "Update commit status during build";
        }

        public String getTriggeredStatusDefault(GhprbSimpleStatus local) {
            return (String)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getTriggeredStatus");
        }

        public String getStatusUrlDefault(GhprbSimpleStatus local) {
            return (String)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getStatusUrl");
        }

        public String getStartedStatusDefault(GhprbSimpleStatus local) {
            return (String)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getStartedStatus");
        }

        public Boolean getAddTestResultsDefault(GhprbSimpleStatus local) {
            return (Boolean)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getAddTestResults");
        }

        public List<GhprbBuildResultMessage> getCompletedStatusDefault(GhprbSimpleStatus local) {
            return (List)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getCompletedStatus");
        }

        public String getCommitStatusContextDefault(GhprbSimpleStatus local) {
            return (String)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getCommitStatusContext");
        }

        public Boolean getShowMatrixStatusDefault(GhprbSimpleStatus local) {
            return (Boolean)Ghprb.getDefaultValue(local, GhprbSimpleStatus.class, "getShowMatrixStatus");
        }

        public boolean addIfMissing() {
            return false;
        }
    }
}

