/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.web.HazelcastInstanceLoader;
import com.hazelcast.web.InvalidateEntryProcessor;
import com.hazelcast.web.SessionAttributePredicate;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class WebFilter
implements Filter {
    private static final ILogger logger = Logger.getLogger(WebFilter.class);
    private static final LocalCacheEntry NULL_ENTRY = new LocalCacheEntry();
    private static final String HAZELCAST_REQUEST = "*hazelcast-request";
    private static final String HAZELCAST_SESSION_COOKIE_NAME = "hazelcast.sessionId";
    static final String HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR = "::hz::";
    private static final ConcurrentMap<String, String> mapOriginalSessions = new ConcurrentHashMap<String, String>(1000);
    private static final ConcurrentMap<String, HazelcastHttpSession> mapSessions = new ConcurrentHashMap<String, HazelcastHttpSession>(1000);
    private HazelcastInstance hazelcastInstance;
    private String clusterMapName = "none";
    private String sessionCookieName = "hazelcast.sessionId";
    private String sessionCookieDomain = null;
    private boolean sessionCookieSecure = false;
    private boolean sessionCookieHttpOnly = false;
    private boolean stickySession = true;
    private boolean shutdownOnDestroy = true;
    private boolean deferredWrite = false;
    private Properties properties;
    protected ServletContext servletContext;
    protected FilterConfig filterConfig;

    public WebFilter() {
    }

    public WebFilter(Properties properties) {
        this();
        this.properties = properties;
    }

    public final void init(FilterConfig config) throws ServletException {
        String deferredWriteParam;
        String shutdownOnDestroyParam;
        String stickySessionParam;
        String cookieHttpOnly;
        String cookieSecure;
        String cookieDomain;
        this.filterConfig = config;
        this.servletContext = config.getServletContext();
        this.initInstance();
        String mapName = this.getParam("map-name");
        this.clusterMapName = mapName != null ? mapName : "_web_" + this.servletContext.getServletContextName();
        try {
            Config hzConfig = this.hazelcastInstance.getConfig();
            String sessionTTL = this.getParam("session-ttl-seconds");
            if (sessionTTL != null) {
                MapConfig mapConfig = hzConfig.getMapConfig(this.clusterMapName);
                mapConfig.setTimeToLiveSeconds(Integer.parseInt(sessionTTL));
                hzConfig.addMapConfig(mapConfig);
            }
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        String cookieName = this.getParam("cookie-name");
        if (cookieName != null) {
            this.sessionCookieName = cookieName;
        }
        if ((cookieDomain = this.getParam("cookie-domain")) != null) {
            this.sessionCookieDomain = cookieDomain;
        }
        if ((cookieSecure = this.getParam("cookie-secure")) != null) {
            this.sessionCookieSecure = Boolean.valueOf(cookieSecure);
        }
        if ((cookieHttpOnly = this.getParam("cookie-http-only")) != null) {
            this.sessionCookieHttpOnly = Boolean.valueOf(cookieHttpOnly);
        }
        if ((stickySessionParam = this.getParam("sticky-session")) != null) {
            this.stickySession = Boolean.valueOf(stickySessionParam);
        }
        if ((shutdownOnDestroyParam = this.getParam("shutdown-on-destroy")) != null) {
            this.shutdownOnDestroy = Boolean.valueOf(shutdownOnDestroyParam);
        }
        if ((deferredWriteParam = this.getParam("deferred-write")) != null) {
            this.deferredWrite = Boolean.parseBoolean(deferredWriteParam);
        }
        if (!this.stickySession) {
            this.getClusterMap().addEntryListener((EntryListener)new EntryListener<String, Object>(){

                public void entryAdded(EntryEvent<String, Object> entryEvent) {
                }

                public void entryRemoved(EntryEvent<String, Object> entryEvent) {
                    if (entryEvent.getMember() == null || !entryEvent.getMember().localMember()) {
                        WebFilter.this.removeSessionLocally((String)entryEvent.getKey());
                    }
                }

                public void entryUpdated(EntryEvent<String, Object> entryEvent) {
                }

                public void entryEvicted(EntryEvent<String, Object> entryEvent) {
                    this.entryRemoved(entryEvent);
                }
            }, false);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sticky:" + this.stickySession + ", shutdown-on-destroy: " + this.shutdownOnDestroy + ", map-name: " + this.clusterMapName);
        }
    }

    private void initInstance() throws ServletException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.setProperty("config-location");
        this.setProperty("instance-name");
        this.setProperty("use-client");
        this.setProperty("client-config-location");
        this.hazelcastInstance = this.getInstance(this.properties);
    }

    private void setProperty(String propertyName) {
        String value = this.getParam(propertyName);
        if (value != null) {
            this.properties.setProperty(propertyName, value);
        }
    }

    private void removeSessionLocally(String sessionId) {
        HazelcastHttpSession hazelSession = (HazelcastHttpSession)mapSessions.remove(sessionId);
        if (hazelSession != null) {
            mapOriginalSessions.remove(hazelSession.originalSession.getId());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Destroying session locally " + hazelSession);
            }
            hazelSession.destroy();
        }
    }

    static void destroyOriginalSession(HttpSession originalSession) {
        HazelcastHttpSession hazelSession;
        String hazelcastSessionId = (String)mapOriginalSessions.remove(originalSession.getId());
        if (hazelcastSessionId != null && (hazelSession = (HazelcastHttpSession)mapSessions.remove(hazelcastSessionId)) != null) {
            hazelSession.webFilter.destroySession(hazelSession, false);
        }
    }

    private String extractAttributeKey(String key) {
        return key.substring(key.indexOf(HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR) + HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR.length());
    }

    private HazelcastHttpSession createNewSession(RequestWrapper requestWrapper, String existingSessionId) {
        String id;
        String string = id = existingSessionId != null ? existingSessionId : WebFilter.generateSessionId();
        if (requestWrapper.getOriginalSession(false) != null) {
            logger.finest("Original session exists!!!");
        }
        HttpSession originalSession = requestWrapper.getOriginalSession(true);
        HazelcastHttpSession hazelcastSession = new HazelcastHttpSession(this, id, originalSession, this.deferredWrite);
        mapSessions.put(hazelcastSession.getId(), hazelcastSession);
        String oldHazelcastSessionId = mapOriginalSessions.put(originalSession.getId(), hazelcastSession.getId());
        if (oldHazelcastSessionId != null && logger.isFinestEnabled()) {
            logger.finest("!!! Overriding an existing hazelcastSessionId " + oldHazelcastSessionId);
        }
        if (logger.isFinestEnabled()) {
            logger.finest("Created new session with id: " + id);
            logger.finest(mapSessions.size() + " is sessions.size and originalSessions.size: " + mapOriginalSessions.size());
        }
        this.addSessionCookie(requestWrapper, id);
        if (this.deferredWrite) {
            this.loadHazelcastSession(hazelcastSession);
        }
        return hazelcastSession;
    }

    private void loadHazelcastSession(HazelcastHttpSession hazelcastSession) {
        Set entrySet = this.getClusterMap().entrySet((Predicate)new SessionAttributePredicate(hazelcastSession.getId()));
        Map cache = hazelcastSession.localCache;
        for (Map.Entry entry : entrySet) {
            String attributeKey = this.extractAttributeKey((String)entry.getKey());
            LocalCacheEntry cacheEntry = (LocalCacheEntry)cache.get(attributeKey);
            if (cacheEntry == null) {
                cacheEntry = new LocalCacheEntry();
                cache.put(attributeKey, cacheEntry);
            }
            if (logger.isFinestEnabled()) {
                logger.finest("Storing " + attributeKey + " on session " + hazelcastSession.getId());
            }
            cacheEntry.value = entry.getValue();
            cacheEntry.dirty = false;
        }
    }

    private void prepareReloadingSession(HazelcastHttpSession hazelcastSession) {
        if (this.deferredWrite && hazelcastSession != null) {
            Map cache = hazelcastSession.localCache;
            for (LocalCacheEntry cacheEntry : cache.values()) {
                cacheEntry.reload = true;
            }
        }
    }

    private void destroySession(HazelcastHttpSession session, boolean removeGlobalSession) {
        if (logger.isFinestEnabled()) {
            logger.finest("Destroying local session: " + session.getId());
        }
        mapSessions.remove(session.getId());
        mapOriginalSessions.remove(session.originalSession.getId());
        session.destroy();
        if (removeGlobalSession) {
            if (logger.isFinestEnabled()) {
                logger.finest("Destroying cluster session: " + session.getId() + " => Ignore-timeout: true");
            }
            IMap<String, Object> clusterMap = this.getClusterMap();
            clusterMap.delete((Object)session.getId());
            clusterMap.executeOnEntries((EntryProcessor)new InvalidateEntryProcessor(session.getId()));
        }
    }

    private IMap<String, Object> getClusterMap() {
        return this.hazelcastInstance.getMap(this.clusterMapName);
    }

    private HazelcastHttpSession getSessionWithId(String sessionId) {
        HazelcastHttpSession session = (HazelcastHttpSession)mapSessions.get(sessionId);
        if (session != null && !session.isValid()) {
            this.destroySession(session, true);
            session = null;
        }
        return session;
    }

    private static synchronized String generateSessionId() {
        char[] chars;
        String id = UuidUtil.buildRandomUuidString();
        StringBuilder sb = new StringBuilder("HZ");
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void addSessionCookie(RequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie(this.sessionCookieName, sessionId);
        String path = req.getContextPath();
        if ("".equals(path)) {
            path = "/";
        }
        sessionCookie.setPath(path);
        sessionCookie.setMaxAge(-1);
        if (this.sessionCookieDomain != null) {
            sessionCookie.setDomain(this.sessionCookieDomain);
        }
        try {
            sessionCookie.setHttpOnly(this.sessionCookieHttpOnly);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        sessionCookie.setSecure(this.sessionCookieSecure);
        req.res.addCookie(sessionCookie);
    }

    private String getSessionCookie(RequestWrapper req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (!name.equalsIgnoreCase(this.sessionCookieName)) continue;
                return value;
            }
        }
        return null;
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
        } else {
            if (req instanceof RequestWrapper) {
                logger.finest("Request is instance of RequestWrapper! Continue...");
                chain.doFilter(req, res);
                return;
            }
            HttpServletRequest httpReq = (HttpServletRequest)req;
            RequestWrapper existingReq = (RequestWrapper)((Object)req.getAttribute(HAZELCAST_REQUEST));
            ResponseWrapper resWrapper = new ResponseWrapper((HttpServletResponse)res);
            RequestWrapper reqWrapper = new RequestWrapper(httpReq, resWrapper);
            if (existingReq != null) {
                reqWrapper.setHazelcastSession(existingReq.hazelcastSession, existingReq.requestedSessionId);
            }
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
            if (existingReq != null) {
                return;
            }
            HazelcastHttpSession session = reqWrapper.getSession(false);
            if (session != null && session.isValid() && (session.sessionChanged() || !this.deferredWrite)) {
                if (logger.isFinestEnabled()) {
                    logger.finest("PUTTING SESSION " + session.getId());
                }
                session.sessionDeferredWrite();
            }
        }
    }

    public final void destroy() {
        mapSessions.clear();
        mapOriginalSessions.clear();
        this.shutdownInstance();
    }

    protected HazelcastInstance getInstance(Properties properties) throws ServletException {
        return HazelcastInstanceLoader.createInstance(this.filterConfig, properties);
    }

    protected void shutdownInstance() {
        if (this.shutdownOnDestroy && this.hazelcastInstance != null) {
            this.hazelcastInstance.getLifecycleService().shutdown();
        }
    }

    private String getParam(String name) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return this.properties.getProperty(name);
        }
        return this.filterConfig.getInitParameter(name);
    }

    private class HazelcastHttpSession
    implements HttpSession {
        private final Map<String, LocalCacheEntry> localCache;
        private final boolean deferredWrite;
        volatile boolean valid = true;
        final String id;
        final HttpSession originalSession;
        final WebFilter webFilter;

        public HazelcastHttpSession(WebFilter webFilter2, String sessionId, HttpSession originalSession, boolean deferredWrite) {
            this.webFilter = webFilter2;
            this.id = sessionId;
            this.originalSession = originalSession;
            this.deferredWrite = deferredWrite;
            this.localCache = deferredWrite ? new ConcurrentHashMap() : null;
        }

        public Object getAttribute(String name) {
            IMap clusterMap = WebFilter.this.getClusterMap();
            if (this.deferredWrite) {
                LocalCacheEntry cacheEntry = this.localCache.get(name);
                if (cacheEntry == null || cacheEntry.reload) {
                    Object value = clusterMap.get((Object)this.buildAttributeName(name));
                    if (value == null) {
                        cacheEntry = NULL_ENTRY;
                    } else {
                        cacheEntry = new LocalCacheEntry();
                        cacheEntry.value = value;
                        cacheEntry.reload = false;
                    }
                    this.localCache.put(name, cacheEntry);
                }
                return cacheEntry != NULL_ENTRY ? cacheEntry.value : null;
            }
            return clusterMap.get((Object)this.buildAttributeName(name));
        }

        public Enumeration<String> getAttributeNames() {
            final Set<String> keys = this.selectKeys();
            return new Enumeration<String>(){
                private final String[] elements;
                private int index;
                {
                    this.elements = keys.toArray(new String[keys.size()]);
                    this.index = 0;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.index < this.elements.length;
                }

                @Override
                public String nextElement() {
                    return this.elements[this.index++];
                }
            };
        }

        public String getId() {
            return this.id;
        }

        public ServletContext getServletContext() {
            return WebFilter.this.servletContext;
        }

        public HttpSessionContext getSessionContext() {
            return this.originalSession.getSessionContext();
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            Set<String> keys = this.selectKeys();
            return keys.toArray(new String[keys.size()]);
        }

        public void invalidate() {
            this.originalSession.invalidate();
            WebFilter.this.destroySession(this, true);
        }

        public boolean isNew() {
            return this.originalSession.isNew();
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            if (this.deferredWrite) {
                LocalCacheEntry entry = this.localCache.get(name);
                if (entry != null) {
                    entry.value = null;
                    entry.removed = true;
                    entry.dirty = true;
                }
            } else {
                WebFilter.this.getClusterMap().delete((Object)this.buildAttributeName(name));
            }
        }

        public void setAttribute(String name, Object value) {
            if (name == null) {
                throw new NullPointerException("name must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            if (this.deferredWrite) {
                LocalCacheEntry entry = this.localCache.get(name);
                if (entry == null) {
                    entry = new LocalCacheEntry();
                    this.localCache.put(name, entry);
                }
                entry.value = value;
                entry.dirty = true;
            } else {
                WebFilter.this.getClusterMap().put((Object)this.buildAttributeName(name), value);
            }
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        public boolean sessionChanged() {
            if (!this.deferredWrite) {
                return false;
            }
            for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                if (!entry.getValue().dirty) continue;
                return true;
            }
            return false;
        }

        public long getCreationTime() {
            return this.originalSession.getCreationTime();
        }

        public long getLastAccessedTime() {
            return this.originalSession.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.originalSession.getMaxInactiveInterval();
        }

        public void setMaxInactiveInterval(int maxInactiveSeconds) {
            this.originalSession.setMaxInactiveInterval(maxInactiveSeconds);
        }

        void destroy() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        private String buildAttributeName(String name) {
            return this.id + WebFilter.HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR + name;
        }

        private void sessionDeferredWrite() {
            IMap clusterMap = WebFilter.this.getClusterMap();
            if (this.deferredWrite) {
                Iterator<Map.Entry<String, LocalCacheEntry>> iterator = this.localCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, LocalCacheEntry> entry = iterator.next();
                    if (!entry.getValue().dirty) continue;
                    LocalCacheEntry cacheEntry = entry.getValue();
                    if (cacheEntry.removed) {
                        clusterMap.delete((Object)this.buildAttributeName(entry.getKey()));
                        iterator.remove();
                        continue;
                    }
                    clusterMap.put((Object)this.buildAttributeName(entry.getKey()), cacheEntry.value);
                    cacheEntry.dirty = false;
                }
            }
            if (!clusterMap.containsKey((Object)this.id)) {
                clusterMap.put((Object)this.id, (Object)Boolean.TRUE);
            }
        }

        private Set<String> selectKeys() {
            HashSet<String> keys = new HashSet<String>();
            if (!this.deferredWrite) {
                for (String qualifiedAttributeKey : WebFilter.this.getClusterMap().keySet((Predicate)new SessionAttributePredicate(this.id))) {
                    keys.add(WebFilter.this.extractAttributeKey(qualifiedAttributeKey));
                }
            } else {
                for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                    if (entry.getValue().removed) continue;
                    keys.add(entry.getKey());
                }
            }
            return keys;
        }
    }

    private static class LocalCacheEntry {
        private Object value;
        volatile boolean dirty = false;
        volatile boolean reload = false;
        boolean removed = false;

        private LocalCacheEntry() {
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        public ResponseWrapper(HttpServletResponse original) {
            super(original);
        }
    }

    private class RequestWrapper
    extends HttpServletRequestWrapper {
        HazelcastHttpSession hazelcastSession;
        final ResponseWrapper res;
        String requestedSessionId;

        public RequestWrapper(HttpServletRequest req, ResponseWrapper res) {
            super(req);
            this.hazelcastSession = null;
            this.res = res;
            req.setAttribute(WebFilter.HAZELCAST_REQUEST, (Object)this);
        }

        public void setHazelcastSession(HazelcastHttpSession hazelcastSession, String requestedSessionId) {
            this.hazelcastSession = hazelcastSession;
            this.requestedSessionId = requestedSessionId;
        }

        HttpSession getOriginalSession(boolean create) {
            return super.getSession(create);
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            final ServletRequest original = this.getRequest();
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).forward(servletRequest, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).include(servletRequest, servletResponse);
                }
            };
        }

        public String fetchHazelcastSessionId() {
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            this.requestedSessionId = WebFilter.this.getSessionCookie(this);
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            this.requestedSessionId = this.getParameter(WebFilter.HAZELCAST_SESSION_COOKIE_NAME);
            return this.requestedSessionId;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelcastHttpSession getSession(boolean create) {
            HttpSession originalSession;
            if (this.hazelcastSession != null && !this.hazelcastSession.isValid()) {
                logger.finest("Session is invalid!");
                WebFilter.this.destroySession(this.hazelcastSession, true);
                this.hazelcastSession = null;
            }
            if (this.hazelcastSession == null && (originalSession = this.getOriginalSession(false)) != null) {
                String hazelcastSessionId = (String)mapOriginalSessions.get(originalSession.getId());
                if (hazelcastSessionId != null) {
                    this.hazelcastSession = (HazelcastHttpSession)mapSessions.get(hazelcastSessionId);
                }
                if (this.hazelcastSession == null) {
                    mapOriginalSessions.remove(originalSession.getId());
                    originalSession.invalidate();
                }
            }
            if (this.hazelcastSession != null) {
                return this.hazelcastSession;
            }
            String requestedSessionId = this.fetchHazelcastSessionId();
            if (requestedSessionId != null) {
                Boolean existing;
                this.hazelcastSession = WebFilter.this.getSessionWithId(requestedSessionId);
                if (this.hazelcastSession == null && (existing = (Boolean)WebFilter.this.getClusterMap().get((Object)requestedSessionId)) != null && existing.booleanValue()) {
                    this.hazelcastSession = WebFilter.this.createNewSession(this, requestedSessionId);
                }
            }
            if (this.hazelcastSession == null && create) {
                this.hazelcastSession = WebFilter.this.createNewSession(this, null);
            }
            if (WebFilter.this.deferredWrite) {
                WebFilter.this.prepareReloadingSession(this.hazelcastSession);
            }
            return this.hazelcastSession;
        }
    }
}

