/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.tpcengine.ReactorBuilder;
import com.hazelcast.internal.tpcengine.ReactorType;
import com.hazelcast.internal.tpcengine.TpcEngineBuilder;
import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerLocator;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class TpcEngine {
    final CountDownLatch terminationLatch;
    private final TpcLogger logger = TpcLoggerLocator.getLogger(TpcEngine.class);
    private final int reactorCount;
    private final Reactor[] reactors;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final TpcEngineBuilder configuration;

    public TpcEngine() {
        this(new TpcEngineBuilder());
    }

    TpcEngine(TpcEngineBuilder tpcEngineBuilder) {
        this.configuration = Preconditions.checkNotNull(tpcEngineBuilder, "tpcEngineBuilder");
        this.reactorCount = tpcEngineBuilder.reactorCount;
        this.reactors = new Reactor[this.reactorCount];
        this.terminationLatch = new CountDownLatch(this.reactorCount);
        ReactorBuilder reactorBuilder = tpcEngineBuilder.reactorBuilder;
        reactorBuilder.engine = this;
        for (int idx = 0; idx < this.reactorCount; ++idx) {
            this.reactors[idx] = reactorBuilder.build();
        }
    }

    public State state() {
        return this.state.get();
    }

    public ReactorType reactorType() {
        return this.configuration.reactorBuilder.type;
    }

    public Reactor[] reactors() {
        return this.reactors;
    }

    public int reactorCount() {
        return this.reactorCount;
    }

    public Reactor reactor(int idx) {
        return this.reactors[idx];
    }

    public void start() {
        State oldState;
        this.logger.info("Starting " + this.reactorCount + " reactors of type [" + String.valueOf((Object)this.reactorType()) + "]");
        do {
            if ((oldState = this.state.get()) == State.NEW) continue;
            throw new IllegalStateException("Can't start TpcEngine, it isn't in NEW state.");
        } while (!this.state.compareAndSet(oldState, State.RUNNING));
        for (Reactor reactor : this.reactors) {
            reactor.start();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void shutdown() {
        block4: while (true) {
            oldState = this.state.get();
            switch (1.$SwitchMap$com$hazelcast$internal$tpcengine$TpcEngine$State[oldState.ordinal()]) {
                case 1: 
                case 2: {
                    if (this.state.compareAndSet(oldState, State.SHUTDOWN)) break;
                    continue block4;
                }
                case 3: 
                case 4: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            var2_2 = this.reactors;
            var3_3 = var2_2.length;
            var4_4 = 0;
            while (true) {
                if (var4_4 < var3_3) ** break;
                continue block4;
                reactor = var2_2[var4_4];
                reactor.shutdown();
                ++var4_4;
            }
            break;
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReactorTerminated() {
        CountDownLatch countDownLatch = this.terminationLatch;
        synchronized (countDownLatch) {
            if (this.terminationLatch.getCount() == 1L) {
                this.state.set(State.TERMINATED);
            }
            this.terminationLatch.countDown();
        }
    }

    public static enum State {
        NEW,
        RUNNING,
        SHUTDOWN,
        TERMINATED;

    }
}

