/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

@SerializableByConvention
public final class DoubleConverter
extends Converter {
    public static final DoubleConverter INSTANCE = new DoubleConverter();

    private DoubleConverter() {
        super(8, QueryDataTypeFamily.DOUBLE);
    }

    @Override
    public Class<?> getValueClass() {
        return Double.class;
    }

    @Override
    public byte asTinyint(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.TINYINT);
        }
        if (Double.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.TINYINT);
        }
        byte converted = (byte)val0;
        if (converted != (int)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.TINYINT);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.SMALLINT);
        }
        if (Double.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.SMALLINT);
        }
        short converted = (short)val0;
        if (converted != (int)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.SMALLINT);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.INTEGER);
        }
        if (Double.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.INTEGER);
        }
        int converted = (int)val0;
        if ((long)converted != (long)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.INTEGER);
        }
        return converted;
    }

    @Override
    public long asBigint(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.BIGINT);
        }
        if (Double.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.BIGINT);
        }
        double truncated = val0 > 0.0 ? Math.floor(val0) : Math.ceil(val0);
        long converted = (long)truncated;
        if ((double)converted != truncated) {
            throw this.numericOverflowError(QueryDataTypeFamily.BIGINT);
        }
        return converted;
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.DECIMAL);
        }
        if (Double.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.DECIMAL);
        }
        return new BigDecimal(val0, QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        double doubleVal = this.cast(val);
        float floatVal = (float)this.cast(val);
        if (Float.isInfinite(floatVal) && !Double.isInfinite(doubleVal)) {
            throw this.numericOverflowError(QueryDataTypeFamily.REAL);
        }
        return floatVal;
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Double.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asDouble(val);
    }

    private double cast(Object val) {
        return (Double)val;
    }
}

