/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class FloorCeilFunction<T>
extends UniExpressionWithType<T> {
    private boolean ceil;

    public FloorCeilFunction() {
    }

    private FloorCeilFunction(Expression<?> operand, QueryDataType resultType, boolean ceil) {
        super(operand, resultType);
        this.ceil = ceil;
    }

    public static Expression<?> create(Expression<?> operand, QueryDataType resultType, boolean ceil) {
        QueryDataType operandType = operand.getType();
        if (MathFunctionUtils.notFractional(operandType) && operandType == resultType) {
            return operand;
        }
        return new FloorCeilFunction(operand, resultType, ceil);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object value = this.operand.eval(row, context);
        if (value == null) {
            return null;
        }
        return (T)FloorCeilFunction.floorCeil(value, this.operand.getType(), this.resultType, this.ceil);
    }

    private static Object floorCeil(Object operandValue, QueryDataType operandType, QueryDataType resultType, boolean ceil) {
        Converter operandConverter = operandType.getConverter();
        switch (resultType.getTypeFamily()) {
            case DECIMAL: {
                BigDecimal operand0 = operandConverter.asDecimal(operandValue);
                RoundingMode roundingMode = ceil ? RoundingMode.CEILING : RoundingMode.FLOOR;
                return operand0.setScale(0, roundingMode);
            }
            case REAL: {
                float operand0 = operandConverter.asReal(operandValue);
                return Float.valueOf((float)(ceil ? Math.ceil(operand0) : Math.floor(operand0)));
            }
            case DOUBLE: {
                double operand0 = operandConverter.asDouble(operandValue);
                return ceil ? Math.ceil(operand0) : Math.floor(operand0);
            }
        }
        throw QueryException.error((String)("Unexpected type: " + String.valueOf(resultType)));
    }

    public int getClassId() {
        return 55;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.ceil);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.ceil = in.readBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloorCeilFunction that = (FloorCeilFunction)o;
        return this.ceil == that.ceil;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ceil ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{operand=" + String.valueOf(this.operand) + ", ceil=" + this.ceil + "}";
    }
}

