/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryCollectionMapper;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryMapper;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlay.OverlayOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.UnaryUnionOp;

class GeometryOverlay {
    public static String OVERLAY_PROPERTY_NAME = "jts.overlay";
    public static String OVERLAY_PROPERTY_VALUE_NG = "ng";
    public static String OVERLAY_PROPERTY_VALUE_OLD = "old";
    public static boolean OVERLAY_NG_DEFAULT;
    private static boolean isOverlayNG;

    GeometryOverlay() {
    }

    static void setOverlayImpl(String overlayImplCode) {
        if (overlayImplCode == null) {
            return;
        }
        isOverlayNG = OVERLAY_NG_DEFAULT;
        if (OVERLAY_PROPERTY_VALUE_NG.equalsIgnoreCase(overlayImplCode)) {
            isOverlayNG = true;
        }
    }

    private static Geometry overlay(Geometry a, Geometry b, int opCode) {
        if (isOverlayNG) {
            return OverlayNGRobust.overlay(a, b, opCode);
        }
        return SnapIfNeededOverlayOp.overlayOp(a, b, opCode);
    }

    static Geometry difference(Geometry a, Geometry b) {
        if (a.isEmpty()) {
            return OverlayOp.createEmptyResult(3, a, b, a.getFactory());
        }
        if (b.isEmpty()) {
            return a.copy();
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b);
        return GeometryOverlay.overlay(a, b, 3);
    }

    static Geometry intersection(Geometry a, Geometry b) {
        if (a.isEmpty() || b.isEmpty()) {
            return OverlayOp.createEmptyResult(1, a, b, a.getFactory());
        }
        if (a.isGeometryCollection()) {
            final Geometry g2 = b;
            return GeometryCollectionMapper.map((GeometryCollection)a, new GeometryMapper.MapOp(){

                @Override
                public Geometry map(Geometry g22) {
                    return g22.intersection(g2);
                }
            });
        }
        return GeometryOverlay.overlay(a, b, 1);
    }

    static Geometry symDifference(Geometry a, Geometry b) {
        if (a.isEmpty() || b.isEmpty()) {
            if (a.isEmpty() && b.isEmpty()) {
                return OverlayOp.createEmptyResult(4, a, b, a.getFactory());
            }
            if (a.isEmpty()) {
                return b.copy();
            }
            if (b.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b);
        return GeometryOverlay.overlay(a, b, 4);
    }

    static Geometry union(Geometry a, Geometry b) {
        if (a.isEmpty() || b.isEmpty()) {
            if (a.isEmpty() && b.isEmpty()) {
                return OverlayOp.createEmptyResult(2, a, b, a.getFactory());
            }
            if (a.isEmpty()) {
                return b.copy();
            }
            if (b.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b);
        return GeometryOverlay.overlay(a, b, 2);
    }

    static Geometry union(Geometry a) {
        if (isOverlayNG) {
            return OverlayNGRobust.union(a);
        }
        return UnaryUnionOp.union(a);
    }

    static {
        isOverlayNG = OVERLAY_NG_DEFAULT = false;
        GeometryOverlay.setOverlayImpl(System.getProperty(OVERLAY_PROPERTY_NAME));
    }
}

