/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.type;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.DynamicRecordType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeHolder;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class DynamicRecordTypeImpl
extends DynamicRecordType {
    private final RelDataTypeHolder holder;

    public DynamicRecordTypeImpl(RelDataTypeFactory typeFactory) {
        this.holder = new RelDataTypeHolder(typeFactory);
        this.computeDigest();
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.holder.getFieldList();
    }

    @Override
    public int getFieldCount() {
        return this.holder.getFieldCount();
    }

    @Override
    public @Nullable RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        Pair<RelDataTypeField, Boolean> pair = this.holder.getFieldOrInsert(fieldName, caseSensitive);
        if (((Boolean)pair.right).booleanValue()) {
            this.computeDigest();
        }
        return (RelDataTypeField)pair.left;
    }

    @Override
    public List<String> getFieldNames() {
        return this.holder.getFieldNames();
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ROW;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new SqlTypeExplicitPrecedenceList(ImmutableList.of());
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(DynamicRecordRow").append(this.getFieldNames()).append(")");
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        SqlTypeFamily family = this.getSqlTypeName().getFamily();
        return family != null ? family : this;
    }
}

