/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import java.util.Arrays;
import java.util.List;

public final class MultiTypeOperandChecker
extends TypedOperandChecker {
    public static final TypedOperandChecker JSON_OR_VARCHAR = new MultiTypeOperandChecker(JSON, VARCHAR);
    private final List<TypedOperandChecker> secondaryOperandCheckers;

    private MultiTypeOperandChecker(TypedOperandChecker primaryTypeChecker, TypedOperandChecker ... secondaryOperandCheckers) {
        super(primaryTypeChecker.type);
        if (secondaryOperandCheckers == null || secondaryOperandCheckers.length == 0) {
            throw new IllegalArgumentException("SecondaryOperandCheckers argument can not be empty");
        }
        this.secondaryOperandCheckers = Arrays.asList(secondaryOperandCheckers);
    }

    @Override
    protected boolean matchesTargetType(RelDataType operandType) {
        return super.matchesTargetType(operandType) || this.secondaryOperandCheckers.stream().anyMatch(typedOperandChecker -> typedOperandChecker.matchesTargetType(operandType));
    }
}

