/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.cost.CostUtils;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.shaded.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelRecordType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.StructKind;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistic;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.AbstractTable;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HazelcastTable
extends AbstractTable {
    private final Table target;
    private final Statistic statistic;
    private final RexNode filter;
    private List<RexNode> projects;
    private RelDataType rowType;
    private final Set<String> hiddenFieldNames = new HashSet<String>();

    public HazelcastTable(Table target, Statistic statistic) {
        this.target = target;
        this.statistic = statistic;
        this.filter = null;
    }

    private HazelcastTable(Table target, Statistic statistic, @Nonnull List<RexNode> projects, @Nullable RelDataType rowType, @Nullable RexNode filter) {
        this.target = target;
        this.statistic = statistic;
        this.projects = projects;
        this.rowType = rowType == null ? this.computeRowType(projects) : rowType;
        this.filter = filter;
    }

    private void initRowType() {
        if (this.rowType == null) {
            int fieldCount = this.target.getFieldCount();
            this.projects = new ArrayList<RexNode>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                Object field = this.target.getField(i);
                RelDataType type = OptUtils.convert(field, HazelcastTypeFactory.INSTANCE);
                this.projects.add(new RexInputRef(i, type));
            }
            this.rowType = this.computeRowType(this.projects);
        }
    }

    public HazelcastTable withProject(List<RexNode> projects, @Nullable RelDataType rowType) {
        return new HazelcastTable(this.target, this.statistic, projects, rowType, this.filter);
    }

    public HazelcastTable withFilter(RexNode filter) {
        return new HazelcastTable(this.target, this.statistic, this.projects, this.rowType, filter);
    }

    @Nonnull
    public List<RexNode> getProjects() {
        this.initRowType();
        return this.projects;
    }

    @Nullable
    public RexNode getFilter() {
        return this.filter;
    }

    public <T extends Table> T getTarget() {
        return (T)this.target;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        this.initRowType();
        return this.rowType;
    }

    @Override
    public Statistic getStatistic() {
        if (this.filter == null) {
            return this.statistic;
        }
        Double selectivity = RelMdUtil.guessSelectivity(this.filter);
        Double rowCount = CostUtils.adjustFilteredRowCount(this.statistic.getRowCount(), selectivity);
        return new AdjustedStatistic(rowCount);
    }

    public double getTotalRowCount() {
        return this.statistic.getRowCount();
    }

    public boolean isHidden(String fieldName) {
        return this.hiddenFieldNames.contains(fieldName);
    }

    public String getSignature() {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        res.setEmptyValue("");
        res.add("projects=" + this.getProjects().stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]")));
        if (this.filter != null) {
            res.add("filter=" + String.valueOf(this.filter));
        }
        return res.toString();
    }

    private RelDataType computeRowType(List<RexNode> projects) {
        ArrayList<RelDataTypeField> typeFields = new ArrayList<RelDataTypeField>(projects.size());
        for (int i = 0; i < projects.size(); ++i) {
            RelDataTypeFieldImpl fieldType;
            RexNode project = projects.get(i);
            if (project instanceof RexInputRef) {
                Object field = this.target.getField(((RexInputRef)project).getIndex());
                fieldType = new RelDataTypeFieldImpl(((TableField)field).getName(), i, project.getType());
                if (((TableField)field).isHidden()) {
                    this.hiddenFieldNames.add(((TableField)field).getName());
                }
            } else {
                fieldType = new RelDataTypeFieldImpl("EXPR$" + i, i, project.getType());
            }
            typeFields.add(fieldType);
        }
        return new RelRecordType(StructKind.PEEK_FIELDS, typeFields, false);
    }

    private final class AdjustedStatistic
    implements Statistic {
        private final Double rowCount;

        private AdjustedStatistic(Double rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public Double getRowCount() {
            return this.rowCount;
        }

        @Override
        public boolean isKey(ImmutableBitSet columns) {
            return HazelcastTable.this.statistic.isKey(columns);
        }

        @Override
        public List<ImmutableBitSet> getKeys() {
            return HazelcastTable.this.statistic.getKeys();
        }

        @Override
        public List<RelReferentialConstraint> getReferentialConstraints() {
            return HazelcastTable.this.statistic.getReferentialConstraints();
        }

        @Override
        public List<RelCollation> getCollations() {
            return HazelcastTable.this.statistic.getCollations();
        }

        @Override
        public RelDistribution getDistribution() {
            return HazelcastTable.this.statistic.getDistribution();
        }
    }
}

