/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.ObjectArrayKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.shaded.com.google.common.collect.LinkedListMultimap;
import com.hazelcast.shaded.com.google.common.collect.Multimap;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SqlHashJoinP
extends AbstractProcessor {
    private final JetJoinInfo joinInfo;
    private final int rightInputColumnCount;
    private ExpressionEvalContext evalContext;
    private Multimap<ObjectArrayKey, JetSqlRow> hashMap;
    private AbstractProcessor.FlatMapper<JetSqlRow, JetSqlRow> flatMapper;
    private long maxItemsInHashTable;

    public SqlHashJoinP(JetJoinInfo joinInfo, int rightInputColumnCount) {
        this.joinInfo = joinInfo;
        this.rightInputColumnCount = rightInputColumnCount;
    }

    public void init(@Nonnull Processor.Context context) throws Exception {
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
        this.hashMap = LinkedListMultimap.create();
        this.flatMapper = this.flatMapper(this::join);
        this.maxItemsInHashTable = context.maxProcessorAccumulatedRecords();
    }

    private Traverser<JetSqlRow> join(JetSqlRow leftRow) {
        ObjectArrayKey joinKeys = ObjectArrayKey.project(leftRow, this.joinInfo.leftEquiJoinIndices());
        Collection<JetSqlRow> matchedRows = this.hashMap.get(joinKeys);
        List output = matchedRows.stream().map(right -> ExpressionUtil.join(leftRow, right, this.joinInfo.nonEquiCondition(), this.evalContext)).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.joinInfo.isLeftOuter() && output.isEmpty()) {
            return Traversers.singleton((Object)leftRow.extendedRow(this.rightInputColumnCount));
        }
        return Traversers.traverseIterable(output);
    }

    protected boolean tryProcess0(@Nonnull Object item) {
        return this.flatMapper.tryProcess((Object)((JetSqlRow)item));
    }

    protected boolean tryProcess1(@Nonnull Object item) {
        if ((long)this.hashMap.size() == this.maxItemsInHashTable) {
            throw new AccumulationLimitExceededException();
        }
        JetSqlRow rightRow = (JetSqlRow)item;
        ObjectArrayKey joinKeys = ObjectArrayKey.project(rightRow, this.joinInfo.rightEquiJoinIndices());
        if (joinKeys.containsNull()) {
            return true;
        }
        this.hashMap.put(joinKeys, rightRow);
        return true;
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public boolean isCooperative() {
        return this.joinInfo.isCooperative();
    }

    public static HashJoinProcessorSupplier supplier(JetJoinInfo joinInfo, int rightInputColumnCount) {
        return new HashJoinProcessorSupplier(joinInfo, rightInputColumnCount);
    }

    public boolean closeIsCooperative() {
        return true;
    }

    private static final class HashJoinProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private JetJoinInfo joinInfo;
        private int rightInputColumnCount;

        private HashJoinProcessorSupplier() {
        }

        private HashJoinProcessorSupplier(JetJoinInfo joinInfo, int rightInputColumnCount) {
            this.joinInfo = joinInfo;
            this.rightInputColumnCount = rightInputColumnCount;
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            ArrayList<SqlHashJoinP> processors = new ArrayList<SqlHashJoinP>(count);
            for (int i = 0; i < count; ++i) {
                processors.add(new SqlHashJoinP(this.joinInfo, this.rightInputColumnCount));
            }
            return processors;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.joinInfo);
            out.writeInt(this.rightInputColumnCount);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.joinInfo = (JetJoinInfo)in.readObject();
            this.rightInputColumnCount = in.readInt();
        }
    }
}

