/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.aggregate.function.ImposeOrderFunction;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.DropLateItemsLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.WatermarkLogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMdWatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.shaded.org.apache.calcite.plan.Convention;
import com.hazelcast.shaded.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;

final class WatermarkRules {
    static final RelOptRule IMPOSE_ORDER_INSTANCE = new RelOptRule(RelOptRule.operandJ(LogicalTableFunctionScan.class, Convention.NONE, scan -> WatermarkRules.extractImposeOrderFunction(scan) != null, RelOptRule.none()), WatermarkRules.class.getSimpleName() + "(Impose Order)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalTableFunctionScan scan = (LogicalTableFunctionScan)call.rel(0);
            int wmIndex = this.orderingColumnFieldIndex(scan);
            WatermarkLogicalRel wmRel = new WatermarkLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), (RelNode)Iterables.getOnlyElement(Util.toList(scan.getInputs(), OptUtils::toLogicalInput)), this.lagExpression(scan), wmIndex);
            if (wmIndex < 0) {
                call.transformTo(wmRel);
                return;
            }
            WatermarkedFields watermarkedFields = HazelcastRelMdWatermarkedFields.watermarkedFieldByIndex(wmIndex);
            if (watermarkedFields == null || watermarkedFields.isEmpty()) {
                call.transformTo(wmRel);
                return;
            }
            int watermarkedField = watermarkedFields.findFirst();
            DropLateItemsLogicalRel dropLateItemsRel = new DropLateItemsLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), wmRel, watermarkedField);
            call.transformTo(dropLateItemsRel);
        }

        private int orderingColumnFieldIndex(LogicalTableFunctionScan function) {
            return ((RexInputRef)((RexCall)WatermarkRules.extractOperand(function, 1)).getOperands().get(0)).getIndex();
        }

        private Expression<?> lagExpression(LogicalTableFunctionScan function) {
            QueryParameterMetadata parameterMetadata = ((HazelcastRelOptCluster)function.getCluster()).getParameterMetadata();
            RexToExpressionVisitor visitor = new RexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, parameterMetadata);
            return (Expression)WatermarkRules.extractOperand(function, 2).accept(visitor);
        }
    };
    static final RelOptRule WATERMARK_INTO_SCAN_INSTANCE = new RelOptRule(RelOptRule.operand(WatermarkLogicalRel.class, RelOptRule.operand(FullScanLogicalRel.class, RelOptRule.none()), new RelOptRuleOperand[0]), WatermarkRules.class.getSimpleName() + "(Watermark Into Scan)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            WatermarkLogicalRel logicalWatermark = (WatermarkLogicalRel)call.rel(0);
            FullScanLogicalRel logicalScan = (FullScanLogicalRel)call.rel(1);
            FullScanLogicalRel scan = new FullScanLogicalRel(logicalWatermark.getCluster(), logicalWatermark.getTraitSet(), logicalScan.getTable(), logicalWatermark.lagExpression(), logicalWatermark.watermarkedColumnIndex());
            call.transformTo(scan);
        }
    };

    private WatermarkRules() {
    }

    private static ImposeOrderFunction extractImposeOrderFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof ImposeOrderFunction)) {
            return null;
        }
        return (ImposeOrderFunction)call.getOperator();
    }

    private static RexNode extractOperand(LogicalTableFunctionScan function, int index) {
        return ((RexCall)function.getCall()).getOperands().get(index);
    }
}

