/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class JsonArrayFunction
extends VariExpression<HazelcastJsonValue> {
    private SqlJsonConstructorNullClause nullClause;

    public JsonArrayFunction() {
    }

    private JsonArrayFunction(Expression<?>[] operands, SqlJsonConstructorNullClause nullClause) {
        super(operands);
        this.nullClause = nullClause;
    }

    public static Expression<?> create(Expression<?>[] operands, SqlJsonConstructorNullClause nullClause) {
        return new JsonArrayFunction(operands, nullClause);
    }

    public int getClassId() {
        return 4;
    }

    @Override
    public HazelcastJsonValue eval(Row row, ExpressionEvalContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean isFirst = true;
        for (Expression operand : this.operands) {
            Object result = operand.eval(row, context);
            if (result == null && !this.keepNulls()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(JsonCreationUtil.serializeValue(result));
        }
        sb.append(']');
        return new HazelcastJsonValue(sb.toString());
    }

    private boolean keepNulls() {
        return this.nullClause != SqlJsonConstructorNullClause.ABSENT_ON_NULL;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.JSON;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.nullClause.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.nullClause = SqlJsonConstructorNullClause.valueOf(in.readString());
    }
}

