/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.oracle;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.Iterator;
import java.util.List;

public class OracleUpsertQueryBuilder
extends AbstractQueryBuilder {
    public OracleUpsertQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        super(jdbcTable, dialect);
        StringBuilder sb = new StringBuilder();
        this.appendMergeClause(sb);
        sb.append(' ');
        this.appendMatchedClause(sb);
        this.query = sb.toString();
    }

    void appendMergeClause(StringBuilder sb) {
        sb.append("MERGE INTO ");
        this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
        sb.append(" TARGET USING (SELECT");
        Iterator<String> it = this.jdbcTable.dbFieldNames().iterator();
        while (it.hasNext()) {
            String dbFieldName = it.next();
            sb.append(" ? as ");
            this.dialect.quoteIdentifier(sb, dbFieldName);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(" FROM dual) SOURCE");
        sb.append(" ON (");
        this.appendPrimaryKeys(sb);
        sb.append(")");
    }

    void appendMatchedClause(StringBuilder sb) {
        sb.append("WHEN MATCHED THEN ");
        sb.append("UPDATE ");
        sb.append("SET ");
        List<String> pkList = this.jdbcTable.getPrimaryKeyList();
        Iterator<String> it = this.jdbcTable.dbFieldNames().iterator();
        boolean needsDelimiter = false;
        while (it.hasNext()) {
            String dbFieldName = it.next();
            if (pkList.contains(dbFieldName)) continue;
            if (needsDelimiter) {
                sb.append(", ");
            }
            sb.append("TARGET.");
            this.dialect.quoteIdentifier(sb, dbFieldName);
            sb.append(" = SOURCE.");
            this.dialect.quoteIdentifier(sb, dbFieldName);
            needsDelimiter = true;
        }
        sb.append(" WHEN NOT MATCHED THEN INSERT ");
        this.appendFieldNames(sb, this.jdbcTable.dbFieldNames());
        sb.append(" VALUES");
        this.appendSourceFieldNames(sb, this.jdbcTable.dbFieldNames());
    }

    void appendPrimaryKeys(StringBuilder sb) {
        List<String> pkFields = this.jdbcTable.getPrimaryKeyList();
        for (int i = 0; i < pkFields.size(); ++i) {
            String field = pkFields.get(i);
            sb.append("TARGET.");
            this.dialect.quoteIdentifier(sb, field);
            sb.append(" = SOURCE.");
            this.dialect.quoteIdentifier(sb, field);
            if (i >= pkFields.size() - 1) continue;
            sb.append(" AND ");
        }
    }

    void appendSourceFieldNames(StringBuilder sb, List<String> fieldNames) {
        sb.append('(');
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            sb.append("SOURCE.");
            this.dialect.quoteIdentifier(sb, fieldName);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    @Override
    protected void appendFieldNames(StringBuilder sb, List<String> fieldNames) {
        sb.append('(');
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            this.dialect.quoteIdentifier(sb, fieldName);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }
}

