/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;

public final class SQLExceptionUtils {
    private SQLExceptionUtils() {
    }

    static boolean isNonTransientException(SQLException e) {
        SQLException next = e.getNextException();
        return e instanceof SQLNonTransientException || e.getCause() instanceof SQLNonTransientException || !SQLExceptionUtils.isTransientCode(e.getSQLState()) || next != null && e != next && SQLExceptionUtils.isNonTransientException(next);
    }

    private static boolean isTransientCode(String code) {
        if (code == null) {
            return false;
        }
        switch (code) {
            case "08000": 
            case "08001": 
            case "08003": 
            case "08004": 
            case "08006": 
            case "08007": 
            case "40001": 
            case "40P01": 
            case "53000": 
            case "53100": 
            case "53200": 
            case "53300": 
            case "53400": 
            case "55000": 
            case "55006": 
            case "55P03": 
            case "57P03": 
            case "58000": 
            case "58030": {
                return true;
            }
        }
        return false;
    }
}

