/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.BufferOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.BufferParameters;

public class BufferCorrectnessTest {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader rdr = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        try {
            new BufferCorrectnessTest().run7();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run7() throws Exception {
        String wkt = "MULTILINESTRING ((1335558.59524 631743.01449, 1335572.28215 631775.89056, 1335573.2578018496 631782.1915185435),  (1335573.2578018496 631782.1915185435, 1335576.62035 631803.90754),  (1335573.2578018496 631782.1915185435, 1335580.70187 631802.08139))";
        Geometry g = this.rdr.read(wkt);
        Geometry buf = g.buffer(15.0);
        System.out.println(buf);
    }

    void run6() throws Exception {
        String wkt = "POLYGON ((589081.1515112884 4518509.334764771, 589103.7370954598 4518497.015419995, 589099.8017397423 4518490.719003885, 589097.1198886324 4518486.20858194, 589090.9424687021 4518475.819013388, 589081.1515112884 4518509.334764771))";
        Geometry g = this.rdr.read(wkt);
        BufferParameters params = new BufferParameters(8, 1, 2, 5.0);
        Geometry buf = new BufferOp(g, params).getResultGeometry(-5.0);
        System.out.println(buf);
    }

    void run5() throws Exception {
        String wkt = "POLYGON ((588722.7612465625 4518964.956739423, 588755.2073151038 4518948.2420851765, 588750.2892019567 4518938.490656119, 588750.2892047082 4518938.490654858, 588741.1098934844 4518920.290260831, 588722.7612465625 4518964.956739423))";
        Geometry g = this.rdr.read(wkt);
        BufferParameters params = new BufferParameters(8, 1, 2, 5.0);
        Geometry buf = new BufferOp(g, params).getResultGeometry(-5.0);
        System.out.println(buf);
    }

    void run4() throws Exception {
        String wkt = "LINESTRING (1872612.157 530840.503, 1872624.713 530767.14, 1872637.269 530693.777)";
        Geometry g = this.rdr.read(wkt);
        BufferParameters params = new BufferParameters(10, 3, 2, 10.0);
        Geometry buf = new BufferOp(g, params).getResultGeometry(200.0);
        System.out.println(buf);
    }

    void run3() throws Exception {
        String wkt = "MULTILINESTRING ((1335558.59524 631743.01449, 1335572.28215 631775.89056, 1335573.2578018496 631782.1915185435),  (1335573.2578018496 631782.1915185435, 1335576.62035 631803.90754), (1335558.59524 631743.01449, 1335573.2578018496 631782.1915185435), (1335573.2578018496 631782.1915185435, 1335580.70187 631802.08139))";
        Geometry g = this.rdr.read(wkt);
        Geometry buf = g.buffer(15.0);
        System.out.println(buf);
    }

    void run2() throws Exception {
        String wkt = "POLYGON ((-2531.310546875 -17.19328498840332, -2518.694580078125 -27.471830368041992, -2564.515869140625 -44.53504943847656, -2531.310546875 -17.19328498840332))";
        Geometry g = this.rdr.read(wkt);
        Geometry buf = g.buffer(1.0, 1);
        System.out.println(buf);
    }

    void run() throws Exception {
        this.doBuffer("LINESTRING (110 320, 280 290, 170 150)", 20.0, -1);
    }

    void doBuffer(String wkt, double dist) throws Exception {
        Geometry g = this.rdr.read(wkt);
        Geometry buf = g.buffer(dist, -4);
        System.out.println(buf);
    }

    void doBuffer(String wkt, double dist, int quadSegs) throws Exception {
        Geometry g = this.rdr.read(wkt);
        Geometry buf = g.buffer(dist, quadSegs);
        System.out.println(buf);
    }
}

