/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.hprtree.HPRtree;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.STRtree;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.util.List;
import test.jts.perf.index.CountItemVisitor;

public class RtreeStressTest {
    private static final int NUM_ITEMS = 1000;
    private static final int NUM_QUERY = 100000;
    private static final double BASE_MIN = -1000.0;
    private static final double BASE_MAX = 1000.0;
    private static final double SIZE_MAX = 100.0;
    HPRtree hpRtree;
    STRtree stRtree;

    public static void main(String[] args) throws Exception {
        RtreeStressTest test = new RtreeStressTest();
        test.run();
    }

    private void run() {
        this.hpRtree = new HPRtree();
        this.stRtree = new STRtree();
        this.loadGrid(1000);
        Stopwatch sw = new Stopwatch();
        this.stRtree.build();
        System.out.println("Build time: " + sw.getTimeString());
        Stopwatch sw2 = new Stopwatch();
        for (int i = 0; i < 100000; ++i) {
            this.queryRandom();
        }
        System.out.println("Query time: " + sw2.getTimeString());
    }

    private void queryRandom() {
        Envelope env = this.randomEnvelope(-1000.0, 1000.0, 1000.0);
        CountItemVisitor hpVisitor = new CountItemVisitor();
        this.hpRtree.query(env, (ItemVisitor)hpVisitor);
        List hprResult = null;
        List strResult = null;
        this.checkResults(hprResult, strResult);
    }

    private void checkResults(List hprResult, List strResult) {
        if (hprResult == null) {
            return;
        }
        if (strResult == null) {
            return;
        }
        System.out.println("Result size: HPR = " + hprResult.size() + " - STR = " + strResult.size());
        if (hprResult.size() != strResult.size()) {
            System.out.println("Result sizes are not equal: HPR = " + hprResult.size() + " - STR = " + strResult.size());
        }
    }

    private void loadRandom(int numItems) {
        for (int i = 0; i < numItems; ++i) {
            Envelope env = this.randomEnvelope(-1000.0, 1000.0, 100.0);
            this.insert(env, i + "");
        }
    }

    private void loadGrid(int numItems) {
        int numSide = (int)Math.sqrt(numItems);
        double gridSize = 2000.0 / (double)numSide;
        for (int i = 0; i < numSide; ++i) {
            for (int j = 0; j < numSide; ++j) {
                Envelope env = new Envelope(-1000.0, -1000.0 + (double)i * gridSize, -1000.0, -1000.0 + (double)j * gridSize);
                this.insert(env, i + "-" + j);
            }
        }
    }

    private Envelope randomEnvelope(double baseMin, double baseMax, double size) {
        double x = RtreeStressTest.random(baseMin, baseMax);
        double y = RtreeStressTest.random(baseMin, baseMax);
        double sizeX = this.random(size);
        double sizeY = this.random(size);
        Envelope env = new Envelope(x, x + sizeX, y, y + sizeY);
        return env;
    }

    private void insert(Envelope env, String id) {
        this.hpRtree.insert(env, (Object)id);
        this.stRtree.insert(env, (Object)id);
    }

    private double random(double x) {
        return x * Math.random();
    }

    private static double random(double x1, double x2) {
        double del = x2 - x1;
        return x1 + del * Math.random();
    }
}

