/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.prep;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import test.jts.perf.ThreadTestCase;
import test.jts.perf.ThreadTestRunner;

public class PreparedGeometryThreadSafeTest
extends ThreadTestCase {
    int nPts = 1000;
    GeometryFactory factory = new GeometryFactory(new PrecisionModel(1.0));
    protected PreparedGeometry pg;
    protected Geometry g;

    public static void main(String[] args) {
        ThreadTestRunner.run(new PreparedGeometryThreadSafeTest());
    }

    @Override
    public void setup() {
        Geometry sinePoly = this.createSineStar(new Coordinate(0.0, 0.0), 100000.0, this.nPts);
        this.pg = PreparedGeometryFactory.prepare((Geometry)sinePoly);
        this.g = this.createSineStar(new Coordinate(10.0, 10.0), 100000.0, 100);
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory(this.factory);
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(20);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    @Override
    public Runnable getRunnable(final int threadIndex) {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    System.out.println(threadIndex);
                    PreparedGeometryThreadSafeTest.this.pg.intersects(PreparedGeometryThreadSafeTest.this.g);
                }
            }
        };
    }
}

