/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.CGAlgorithmsDD;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.Intersection;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;
import test.jts.perf.algorithm.IntersectionAlgorithms;

public class IntersectionPerfTest
extends PerformanceTestCase {
    private static final int N_ITER = 1000000;
    Coordinate a0 = new Coordinate(0.0, 0.0);
    Coordinate a1 = new Coordinate(10.0, 0.0);
    Coordinate b0 = new Coordinate(20.0, 10.0);
    Coordinate b1 = new Coordinate(20.0, 20.0);
    Coordinate p0;
    Coordinate p1;
    Coordinate q0;
    Coordinate q1;

    public static void main(String[] args) {
        PerformanceTestRunner.run(IntersectionPerfTest.class);
    }

    public IntersectionPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{1});
        this.setRunIterations(1000000);
    }

    @Override
    public void startRun(int npts) {
        this.p0 = new Coordinate(3.56134716165017E7, 4257145.306132293);
        this.p1 = new Coordinate(3.56134777705378E7, 4257160.528222711);
        this.q0 = new Coordinate(3.561347777505724E7, 4257160.539653536);
        this.q1 = new Coordinate(3.561347985607389E7, 4257165.923691704);
    }

    public void runDP() {
        Coordinate intPt = IntersectionAlgorithms.intersectionBasic(this.p0, this.p1, this.q0, this.q1);
    }

    public void runDD() {
        Coordinate intPt = CGAlgorithmsDD.intersection((Coordinate)this.p0, (Coordinate)this.p1, (Coordinate)this.q0, (Coordinate)this.q1);
    }

    public void runDDWithFilter() {
        Coordinate intPt = IntersectionAlgorithms.intersectionDDWithFilter(this.p0, this.p1, this.q0, this.q1);
    }

    public void runCB() {
        Coordinate intPt = IntersectionAlgorithms.intersectionCB(this.p0, this.p1, this.q0, this.q1);
    }

    public void runCond() {
        Coordinate intPt = Intersection.intersection((Coordinate)this.p0, (Coordinate)this.p1, (Coordinate)this.q0, (Coordinate)this.q1);
    }

    public void runDP_easy() {
        Coordinate intPt = IntersectionAlgorithms.intersectionBasic(this.a0, this.a1, this.b0, this.b1);
    }

    public void runCond_easy() {
        Coordinate intPt = Intersection.intersection((Coordinate)this.a0, (Coordinate)this.a1, (Coordinate)this.b0, (Coordinate)this.b1);
    }

    public void runDD_easy() {
        Coordinate intPt = CGAlgorithmsDD.intersection((Coordinate)this.a0, (Coordinate)this.a1, (Coordinate)this.b0, (Coordinate)this.b1);
    }

    public void runDDWithFilter_easy() {
        Coordinate intPt = IntersectionAlgorithms.intersectionDDWithFilter(this.a0, this.a1, this.b0, this.b1);
    }
}

