/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.CoreQueryUtils;
import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.annotation.Repeat;
import com.hazelcast.version.MemberVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryUtilsTest
extends CoreSqlTestSupport {
    private final TestHazelcastInstanceFactory factory = new TestHazelcastInstanceFactory(1);

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    @Test
    public void testVersionMismatch() {
        HazelcastInstance member = this.factory.newHazelcastInstance();
        NodeEngineImpl nodeEngine = Accessors.getNodeEngineImpl((HazelcastInstance)member);
        String memberId = nodeEngine.getLocalMember().getUuid().toString();
        String memberVersion = nodeEngine.getLocalMember().getVersion().toString();
        try {
            QueryUtils.createPartitionMap((NodeEngine)nodeEngine, (MemberVersion)new MemberVersion(0, 0, 0), (boolean)false);
            Assert.fail((String)"Must fail");
        }
        catch (QueryException e) {
            Assert.assertEquals((long)-1L, (long)e.getCode());
            Assert.assertEquals((Object)("Cannot execute SQL query when members have different versions (make sure that all members have the same version) {localMemberId=" + memberId + ", localMemberVersion=0.0.0, remoteMemberId=" + memberId + ", remoteMemberVersion=" + memberVersion + "}"), (Object)e.getMessage());
        }
    }

    @Test
    public void testUnassignedPartition_ignore() {
        HazelcastInstance member = this.factory.newHazelcastInstance();
        member.getCluster().changeClusterState(ClusterState.FROZEN);
        Map map = QueryUtils.createPartitionMap((NodeEngine)Accessors.getNodeEngineImpl((HazelcastInstance)member), null, (boolean)false);
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testUnassignedPartition_exception() {
        HazelcastInstance member = this.factory.newHazelcastInstance();
        member.getCluster().changeClusterState(ClusterState.FROZEN);
        try {
            QueryUtils.createPartitionMap((NodeEngine)Accessors.getNodeEngineImpl((HazelcastInstance)member), null, (boolean)true);
            Assert.fail((String)"Must fail");
        }
        catch (QueryException e) {
            Assert.assertEquals((long)1005L, (long)e.getCode());
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Partition is not assigned to any member"));
        }
    }

    @Test
    @Repeat(value=5)
    public void test_findLightJobCoordinator() {
        MemberVersion v1 = MemberVersion.of((int)0, (int)1, (int)0);
        MemberVersion v2 = MemberVersion.of((int)0, (int)2, (int)0);
        MemberVersion v3 = MemberVersion.of((int)0, (int)3, (int)0);
        Member mv1 = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv1.getVersion()).thenReturn((Object)v1);
        Member mv1_1 = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv1_1.getVersion()).thenReturn((Object)v1);
        Member mv1_lite = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv1_lite.getVersion()).thenReturn((Object)v1);
        Mockito.when((Object)mv1_lite.isLiteMember()).thenReturn((Object)true);
        Member mv2 = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv2.getVersion()).thenReturn((Object)v2);
        Member mv2_1 = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv2_1.getVersion()).thenReturn((Object)v2);
        Member mv2_lite = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv2_lite.getVersion()).thenReturn((Object)v2);
        Mockito.when((Object)mv2_lite.isLiteMember()).thenReturn((Object)true);
        Member mv3 = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)mv3.getVersion()).thenReturn((Object)v3);
        Assert.assertNull((Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Collections.emptyList(), null));
        Assert.assertNull((Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Collections.singletonList(mv1_lite), null));
        Assert.assertNull((Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Collections.singletonList(mv1_lite), (Member)mv1_lite));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv2, mv3), null)).isInstanceOf(RuntimeException.class)).hasMessage("More than 2 distinct member versions found: 0.1, 0.2, 0.3");
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Collections.singletonList(mv1), (Member)mv1));
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1), (Member)mv1));
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1_1, mv1), (Member)mv1));
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_lite), (Member)mv1));
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_lite), (Member)mv1_lite));
        Assert.assertSame((Object)mv2, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv2), (Member)mv1));
        Assert.assertSame((Object)mv2, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv2), (Member)mv2));
        Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1, mv2), (Member)mv1));
        Assert.assertSame((Object)mv2, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1_lite, mv1_lite, mv2), null));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1), null)));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1_1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1), null)));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1), (Member)mv2)));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1_1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1), (Member)mv2)));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1, mv2), (Member)mv2)));
        QueryUtilsTest.assertTrueEventuallyFast(() -> Assert.assertSame((Object)mv1_1, (Object)CoreQueryUtils.memberOfLargerSameVersionGroup(Arrays.asList(mv1, mv1_1, mv2), (Member)mv2)));
    }

    private static void assertTrueEventuallyFast(Runnable r) {
        for (int i = 0; i < 1000; ++i) {
            try {
                r.run();
                return;
            }
            catch (AssertionError assertionError) {
                continue;
            }
        }
        Assert.fail((String)"tried 1000 times and failed");
    }
}

