/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlMetadataTest
extends CoreSqlTestSupport {
    @Test
    public void testColumnMetadata() {
        SqlColumnMetadata column = new SqlColumnMetadata("a", SqlColumnType.INTEGER, true);
        Assert.assertEquals((Object)"a", (Object)column.getName());
        Assert.assertEquals((Object)SqlColumnType.INTEGER, (Object)column.getType());
        Assert.assertEquals((Object)"a INTEGER", (Object)column.toString());
        SqlMetadataTest.checkEquals(column, new SqlColumnMetadata("a", SqlColumnType.INTEGER, true), true);
        SqlMetadataTest.checkEquals(column, new SqlColumnMetadata("b", SqlColumnType.INTEGER, true), false);
        SqlMetadataTest.checkEquals(column, new SqlColumnMetadata("a", SqlColumnType.BIGINT, true), false);
    }

    @Test
    public void testRow() {
        SqlColumnMetadata column0Metadata = new SqlColumnMetadata("a", SqlColumnType.INTEGER, true);
        SqlColumnMetadata column1Metadata = new SqlColumnMetadata("b", SqlColumnType.VARCHAR, true);
        SqlRowImpl row = new SqlRowImpl(new SqlRowMetadata(Arrays.asList(column0Metadata, column1Metadata)), new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1, "2"}));
        Assert.assertEquals((Object)"[a INTEGER=1, b VARCHAR=2]", (Object)row.toString());
    }

    @Test
    public void testRowMetadata() {
        SqlColumnMetadata column0 = new SqlColumnMetadata("a", SqlColumnType.INTEGER, true);
        SqlColumnMetadata column1 = new SqlColumnMetadata("b", SqlColumnType.BIGINT, true);
        SqlColumnMetadata column2 = new SqlColumnMetadata("c", SqlColumnType.VARCHAR, true);
        SqlRowMetadata row = new SqlRowMetadata(Arrays.asList(column0, column1));
        Assert.assertEquals((Object)"[a INTEGER, b BIGINT]", (Object)row.toString());
        Assert.assertEquals((long)2L, (long)row.getColumnCount());
        Assert.assertEquals((Object)column0, (Object)row.getColumn(0));
        Assert.assertEquals((Object)column1, (Object)row.getColumn(1));
        Assert.assertEquals((long)0L, (long)row.findColumn("a"));
        Assert.assertEquals((long)1L, (long)row.findColumn("b"));
        Assert.assertEquals((long)-1L, (long)row.findColumn("c"));
        SqlMetadataTest.assertThrows(IndexOutOfBoundsException.class, () -> row.getColumn(-1));
        SqlMetadataTest.assertThrows(IndexOutOfBoundsException.class, () -> row.getColumn(2));
        SqlMetadataTest.checkEquals(row, new SqlRowMetadata(Arrays.asList(column0, column1)), true);
        SqlMetadataTest.checkEquals(row, new SqlRowMetadata(Collections.singletonList(column0)), false);
        SqlMetadataTest.checkEquals(row, new SqlRowMetadata(Arrays.asList(column0, column2)), false);
        SqlMetadataTest.checkEquals(row, new SqlRowMetadata(Arrays.asList(column0, column1, column2)), false);
    }

    @Test
    public void testConversions() {
        String name = "a";
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.BOOLEAN, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.BOOLEAN, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TINYINT, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TINYINT, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.SMALLINT, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.SMALLINT, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.INTEGER, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.INT, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.BIGINT, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.BIGINT, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.DECIMAL, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.DECIMAL, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.DECIMAL_BIG_INTEGER, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.REAL, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.REAL, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.DOUBLE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.DOUBLE, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.VARCHAR, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.VARCHAR, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.VARCHAR, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.VARCHAR_CHARACTER, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.DATE, false), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.DATE, (boolean)false));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIME, false), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIME, (boolean)false));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP, false), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP, (boolean)false));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_DATE, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_CALENDAR, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_INSTANT, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, (boolean)true));
        Assert.assertEquals((Object)SqlMetadataTest.column(name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true), (Object)QueryUtils.getColumnMetadata((String)name, (QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME, (boolean)true));
    }

    private static SqlColumnMetadata column(String name, SqlColumnType type, boolean nullable) {
        return new SqlColumnMetadata(name, type, nullable);
    }
}

