/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.triangulate.tri;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Orientation;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.tri.Tri;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.tri.TriangulationBuilder;
import java.util.ArrayList;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class TriTest
extends GeometryTestCase {
    private static Tri triCentre = TriTest.createSimpleTriangulation();
    private static Tri tri0;
    private static Tri tri1;
    private static Tri tri2;

    public static void main(String[] args) {
        TestRunner.run(TriTest.class);
    }

    public TriTest(String name) {
        super(name);
    }

    public void testAdjacent() {
        TriTest.assertTrue((tri0 == triCentre.getAdjacent(0) ? 1 : 0) != 0);
        TriTest.assertTrue((tri1 == triCentre.getAdjacent(1) ? 1 : 0) != 0);
        TriTest.assertTrue((tri2 == triCentre.getAdjacent(2) ? 1 : 0) != 0);
    }

    public void testMidpoint() {
        Tri tri = TriTest.tri(0.0, 0.0, 0.0, 10.0, 10.0, 0.0);
        this.checkEqualXY(new Coordinate(0.0, 5.0), tri.midpoint(0));
        this.checkEqualXY(new Coordinate(5.0, 5.0), tri.midpoint(1));
        this.checkEqualXY(new Coordinate(5.0, 0.0), tri.midpoint(2));
    }

    public void testCoordinateIndex() {
        Tri tri = TriTest.tri(0.0, 0.0, 0.0, 10.0, 10.0, 0.0);
        TriTest.assertEquals((int)0, (int)tri.getIndex(new Coordinate(0.0, 0.0)));
        TriTest.assertEquals((int)1, (int)tri.getIndex(new Coordinate(0.0, 10.0)));
        TriTest.assertEquals((int)2, (int)tri.getIndex(new Coordinate(10.0, 0.0)));
    }

    private static Tri tri(double x0, double y0, double x1, double y1, double x2, double y2) {
        Tri tri = Tri.create((Coordinate)new Coordinate(x0, y0), (Coordinate)new Coordinate(x1, y1), (Coordinate)new Coordinate(x2, y2));
        TriTest.assertTrue((-1 == Orientation.index((Coordinate)tri.getCoordinate(0), (Coordinate)tri.getCoordinate(1), (Coordinate)tri.getCoordinate(2)) ? 1 : 0) != 0);
        return tri;
    }

    private static Tri createSimpleTriangulation() {
        Tri tri = TriTest.tri(10.0, 10.0, 10.0, 20.0, 20.0, 10.0);
        tri0 = TriTest.tri(10.0, 20.0, 10.0, 10.0, 0.0, 10.0);
        tri1 = TriTest.tri(20.0, 10.0, 10.0, 20.0, 20.0, 20.0);
        tri2 = TriTest.tri(10.0, 10.0, 20.0, 10.0, 10.0, 0.0);
        TriTest.build(tri, tri0, tri1, tri2);
        return tri;
    }

    private static void build(Tri ... tri) {
        ArrayList<Tri> triList = new ArrayList<Tri>();
        for (int i = 0; i < tri.length; ++i) {
            triList.add(tri[i]);
        }
        TriangulationBuilder.build(triList);
    }
}

