/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.BoundaryNodeRule;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateArrays;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPoint;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.IsSimpleOp;
import java.util.Collection;
import java.util.List;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class IsSimpleTest
extends GeometryTestCase {
    private static final double TOLERANCE = 5.0E-5;

    public static void main(String[] args) {
        TestRunner.run(IsSimpleTest.class);
    }

    public IsSimpleTest(String name) {
        super(name);
    }

    public void test2TouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING((0 1, 1 1, 2 1), (0 0, 1 0, 2 1))";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
    }

    public void test3TouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((0 1, 1 1, 2 1),   (0 0, 1 0, 2 1),  (0 2, 1 2, 2 1))";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true, new Coordinate(2.0, 1.0));
    }

    public void testCross() throws Exception {
        String a = "MULTILINESTRING ((20 120, 120 20), (20 20, 120 120))";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, false, new Coordinate(70.0, 70.0));
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, false, new Coordinate(70.0, 70.0));
    }

    public void testMultiLineStringWithRingTouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((100 100, 20 20, 200 20, 100 100), (100 200, 100 100))";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, false, new Coordinate(100.0, 100.0));
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testRing() throws Exception {
        String a = "LINESTRING (100 100, 20 20, 200 20, 100 100)";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testLineRepeatedStart() {
        String a = "LINESTRING (100 100, 100 100, 20 20, 200 20, 100 100)";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testLineRepeatedEnd() {
        String a = "LINESTRING (100 100, 20 20, 200 20, 100 100, 100 100)";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testLineRepeatedBothEnds() {
        String a = "LINESTRING (100 100, 100 100, 100 100, 20 20, 200 20, 100 100, 100 100)";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testLineRepeatedAll() {
        String a = "LINESTRING (100 100, 100 100, 100 100)";
        this.checkIsSimple(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
        this.checkIsSimple(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, true);
    }

    public void testLinesAll() {
        this.checkIsSimpleAll("MULTILINESTRING ((10 20, 90 20), (10 30, 90 30), (50 40, 50 10))", BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT((50 20), (50 30))");
    }

    public void testPolygonAll() {
        this.checkIsSimpleAll("POLYGON ((0 0, 7 0, 6 -1, 6 -0.1, 6 0.1, 3 5.9, 3 6.1, 3.1 6, 2.9 6, 0 0))", BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT((6 0), (3 6))");
    }

    public void testMultiPointAll() {
        this.checkIsSimpleAll("MULTIPOINT((1 1), (1 2), (1 2), (1 3), (1 4), (1 4), (1 5), (1 5))", BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT((1 2), (1 4), (1 5))");
    }

    public void testGeometryCollectionAll() {
        this.checkIsSimpleAll("GEOMETRYCOLLECTION(MULTILINESTRING ((10 20, 90 20), (10 30, 90 30), (50 40, 50 10)), MULTIPOINT((1 1), (1 2), (1 2), (1 3), (1 4), (1 4), (1 5), (1 5)))", BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT((50 20), (50 30), (1 2), (1 4), (1 5))");
    }

    private void checkIsSimple(String wkt, BoundaryNodeRule bnRule, boolean expectedResult) {
        this.checkIsSimple(wkt, bnRule, expectedResult, null);
    }

    private void checkIsSimple(String wkt, BoundaryNodeRule bnRule, boolean expectedResult, Coordinate expectedLocation) {
        Geometry g = this.read(wkt);
        IsSimpleOp op = new IsSimpleOp(g, bnRule);
        boolean isSimple = op.isSimple();
        Coordinate nonSimpleLoc = op.getNonSimpleLocation();
        IsSimpleTest.assertTrue((isSimple || nonSimpleLoc != null ? 1 : 0) != 0);
        IsSimpleTest.assertTrue((expectedResult == isSimple ? 1 : 0) != 0);
        if (!isSimple && expectedLocation != null) {
            IsSimpleTest.assertTrue((expectedLocation.distance(nonSimpleLoc) < 5.0E-5 ? 1 : 0) != 0);
        }
    }

    private void checkIsSimpleAll(String wkt, BoundaryNodeRule bnRule, String wktExpectedPts) {
        Geometry g = this.read(wkt);
        IsSimpleOp op = new IsSimpleOp(g, bnRule);
        op.setFindAllLocations(true);
        op.isSimple();
        List nonSimpleCoords = op.getNonSimpleLocations();
        MultiPoint nsPts = g.getFactory().createMultiPointFromCoords(CoordinateArrays.toCoordinateArray((Collection)nonSimpleCoords));
        Geometry expectedPts = this.read(wktExpectedPts);
        this.checkEqual(expectedPts, (Geometry)nsPts);
    }
}

