/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.union;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.TopologyException;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.OverlapUnion;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class OverlapUnionTest
extends GeometryTestCase {
    public OverlapUnionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(OverlapUnionTest.class);
    }

    public void testFixedPrecCausingBorderChange() throws ParseException {
        String a = "POLYGON ((130 -10, 20 -10, 20 22, 30 20, 130 20, 130 -10))";
        String b = "MULTIPOLYGON (((50 0, 100 450, 100 0, 50 0)), ((53 28, 50 28, 50 30, 53 30, 53 28)))";
        this.checkUnionWithTopologyFailure(a, b, 1.0);
    }

    public void testFullPrecision() throws ParseException {
        String a = "POLYGON ((130 -10, 20 -10, 20 22, 30 20, 130 20, 130 -10))";
        String b = "MULTIPOLYGON (((50 0, 100 450, 100 0, 50 0)), ((53 28, 50 28, 50 30, 53 30, 53 28)))";
        this.checkUnion(a, b);
    }

    public void testSimpleOverlap() throws ParseException {
        String a = "MULTIPOLYGON (((0 400, 50 400, 50 350, 0 350, 0 400)), ((200 200, 220 200, 220 180, 200 180, 200 200)), ((350 100, 370 100, 370 80, 350 80, 350 100)))";
        String b = "MULTIPOLYGON (((430 20, 450 20, 450 0, 430 0, 430 20)), ((100 300, 124 300, 124 276, 100 276, 100 300)), ((230 170, 210 170, 210 190, 230 190, 230 170)))";
        this.checkUnionOptimized(a, b);
    }

    private void checkUnionWithTopologyFailure(String wktA, String wktB, double scaleFactor) throws ParseException {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        GeometryFactory geomFact = new GeometryFactory(pm);
        WKTReader rdr = new WKTReader(geomFact);
        Geometry a = rdr.read(wktA);
        Geometry b = rdr.read(wktB);
        OverlapUnion union = new OverlapUnion(a, b);
        Geometry result = null;
        try {
            result = union.union();
        }
        catch (TopologyException ex) {
            boolean isOptimized = union.isUnionOptimized();
            if (isOptimized) {
                throw ex;
            }
            return;
        }
        OverlapUnionTest.assertTrue((String)"OverlapUnion result is invalid", (boolean)result.isValid());
    }

    private void checkUnion(String wktA, String wktB) throws ParseException {
        this.checkUnion(wktA, wktB, false);
    }

    private void checkUnionOptimized(String wktA, String wktB) throws ParseException {
        this.checkUnion(wktA, wktB, true);
    }

    private void checkUnion(String wktA, String wktB, boolean isCheckOptimized) throws ParseException {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory geomFact = new GeometryFactory(pm);
        WKTReader rdr = new WKTReader(geomFact);
        Geometry a = rdr.read(wktA);
        Geometry b = rdr.read(wktB);
        OverlapUnion union = new OverlapUnion(a, b);
        Geometry result = union.union();
        if (isCheckOptimized) {
            boolean isOptimized = union.isUnionOptimized();
            OverlapUnionTest.assertTrue((String)"Union was not performed using combine", (boolean)isOptimized);
        }
        OverlapUnionTest.assertTrue((String)"OverlapUnion result is invalid", (boolean)result.isValid());
    }
}

