/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.union;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.operation.union.CascadedPolygonUnionTester;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import test.jts.util.IOUtil;

public class CascadedPolygonUnionFileTest
extends TestCase {
    private static CascadedPolygonUnionTester tester = new CascadedPolygonUnionTester();

    public CascadedPolygonUnionFileTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CascadedPolygonUnionFileTest.class);
    }

    public void testAfrica2() throws Exception {
        this.runTestResource("../../../../../data/africa.wkt", 0.999999);
    }

    public void XtestEurope() throws Exception {
        this.runTestResource("../../../../../data/europe.wkt", 0.999999);
    }

    private void runTest(String filename, double minimumMeasure) throws IOException, ParseException {
        List<Geometry> geoms = IOUtil.readWKTFile(filename);
        CascadedPolygonUnionFileTest.assertTrue((boolean)tester.test(geoms, minimumMeasure));
    }

    private void runTestResource(String resource, double minimumMeasure) throws IOException, ParseException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        if (is == null) {
            return;
        }
        List<Geometry> geoms = IOUtil.readWKTFile(new InputStreamReader(is));
        CascadedPolygonUnionFileTest.assertTrue((boolean)tester.test(geoms, minimumMeasure));
    }
}

