/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.distance;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import test.jts.util.IOUtil;

public class DiscreteHausdorffDistanceTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(DiscreteHausdorffDistanceTest.class);
    }

    public DiscreteHausdorffDistanceTest(String name) {
        super(name);
    }

    public void testLineSegments() throws Exception {
        this.runTest("LINESTRING (0 0, 2 1)", "LINESTRING (0 0, 2 0)", 1.0);
    }

    public void testLineSegments2() throws Exception {
        this.runTest("LINESTRING (0 0, 2 0)", "LINESTRING (0 1, 1 2, 2 1)", 2.0);
    }

    public void testLinePoints() throws Exception {
        this.runTest("LINESTRING (0 0, 2 0)", "MULTIPOINT (0 1, 1 0, 2 1)", 1.0);
    }

    public void testLinesShowingDiscretenessEffect() throws Exception {
        this.runTest("LINESTRING (130 0, 0 0, 0 150)", "LINESTRING (10 10, 10 150, 130 10)", 14.142135623730951);
        this.runTest("LINESTRING (130 0, 0 0, 0 150)", "LINESTRING (10 10, 10 150, 130 10)", 0.5, 70.0);
    }

    private void runTest(String wkt1, String wkt2, double expectedDistance) throws ParseException {
        Geometry g1 = IOUtil.readWKT(wkt1);
        Geometry g2 = IOUtil.readWKT(wkt2);
        double distance = DiscreteHausdorffDistance.distance((Geometry)g1, (Geometry)g2);
        DiscreteHausdorffDistanceTest.assertEquals((double)distance, (double)expectedDistance, (double)1.0E-5);
    }

    private void runTest(String wkt1, String wkt2, double densifyFrac, double expectedDistance) throws ParseException {
        Geometry g1 = IOUtil.readWKT(wkt1);
        Geometry g2 = IOUtil.readWKT(wkt2);
        double distance = DiscreteHausdorffDistance.distance((Geometry)g1, (Geometry)g2, (double)densifyFrac);
        DiscreteHausdorffDistanceTest.assertEquals((double)distance, (double)expectedDistance, (double)1.0E-5);
    }
}

