/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.PointLocation;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class PointLocationOn4DLineTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PointLocationOn4DLineTest.class);
    }

    public PointLocationOn4DLineTest(String name) {
        super(name);
    }

    public void testOnVertex() throws Exception {
        this.checkOnLine(20.0, 20.0, "LINESTRINGZM (0 0 0 0, 20 20 20 20, 30 30 30 30)", true);
    }

    public void testOnSegment() throws Exception {
        this.checkOnLine(10.0, 10.0, "LINESTRINGZM (0 0 0 0, 20 20 20 20, 0 40 40 40)", true);
        this.checkOnLine(10.0, 30.0, "LINESTRINGZM (0 0 0 0, 20 20 20 20, 0 40 40 40)", true);
    }

    public void testNotOnLine() throws Exception {
        this.checkOnLine(0.0, 100.0, "LINESTRINGZM (10 10 10 10, 20 10 10 10, 30 10 10 10)", false);
    }

    void checkOnLine(double x, double y, String wktLine, boolean expected) {
        LineString line = (LineString)this.read(wktLine);
        PointLocationOn4DLineTest.assertTrue((expected == PointLocation.isOnLine((Coordinate)new Coordinate(x, y), (Coordinate[])line.getCoordinates()) ? 1 : 0) != 0);
        PointLocationOn4DLineTest.assertTrue((expected == PointLocation.isOnLine((Coordinate)new Coordinate(x, y), (CoordinateSequence)line.getCoordinateSequence()) ? 1 : 0) != 0);
    }
}

