/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.inference;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.AlternativeHypothesis;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.BinomialTest;
import org.junit.Assert;
import org.junit.Test;

public class BinomialTestTest {
    protected BinomialTest testStatistic = new BinomialTest();
    private static int successes = 51;
    private static int trials = 235;
    private static double probability = 0.16666666666666666;

    @Test
    public void testBinomialTestPValues() {
        Assert.assertEquals((double)0.04375, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED), (double)1.0E-4);
        Assert.assertEquals((double)0.02654, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN), (double)1.0E-4);
        Assert.assertEquals((double)0.982, (double)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN), (double)1.0E-4);
    }

    @Test
    public void testBinomialTestExceptions() {
        try {
            this.testStatistic.binomialTest(10, -1, 0.5, AlternativeHypothesis.TWO_SIDED);
            Assert.fail((String)"Expected not positive exception");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            this.testStatistic.binomialTest(10, 11, 0.5, AlternativeHypothesis.TWO_SIDED);
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.binomialTest(10, 11, 0.5, null);
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBinomialTestAcceptReject() {
        double alpha05 = 0.05;
        double alpha01 = 0.01;
        Assert.assertTrue((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED, alpha05));
        Assert.assertTrue((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN, alpha05));
        Assert.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN, alpha05));
        Assert.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.TWO_SIDED, alpha01));
        Assert.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.GREATER_THAN, alpha01));
        Assert.assertFalse((boolean)this.testStatistic.binomialTest(trials, successes, probability, AlternativeHypothesis.LESS_THAN, alpha05));
    }
}

