/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive;

import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.ListUnivariateImpl;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.NumberTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.util.TransformerMap;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public final class MixedListUnivariateImplTest {
    private double one = 1.0;
    private float two = 2.0f;
    private int three = 3;
    private double mean = 2.0;
    private double sumSq = 18.0;
    private double sum = 8.0;
    private double var = 0.6666666666666666;
    private double std = FastMath.sqrt((double)this.var);
    private double n = 4.0;
    private double min = 1.0;
    private double max = 3.0;
    private double tolerance = 1.0E-14;
    private TransformerMap transformers = new TransformerMap();

    public MixedListUnivariateImplTest() {
        this.transformers.putTransformer(Foo.class, (NumberTransformer)new FooTransformer());
        this.transformers.putTransformer(Bar.class, (NumberTransformer)new BarTransformer());
    }

    @Test
    public void testStats() {
        ArrayList<Object> externalList = new ArrayList<Object>();
        ListUnivariateImpl u = new ListUnivariateImpl(externalList, (NumberTransformer)this.transformers);
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)this.tolerance);
        u.addValue(this.one);
        u.addValue(this.two);
        u.addValue(this.two);
        u.addValue(this.three);
        Assert.assertEquals((String)"N", (double)this.n, (double)u.getN(), (double)this.tolerance);
        Assert.assertEquals((String)"sum", (double)this.sum, (double)u.getSum(), (double)this.tolerance);
        Assert.assertEquals((String)"sumsq", (double)this.sumSq, (double)u.getSumsq(), (double)this.tolerance);
        Assert.assertEquals((String)"var", (double)this.var, (double)u.getVariance(), (double)this.tolerance);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)this.tolerance);
        Assert.assertEquals((String)"mean", (double)this.mean, (double)u.getMean(), (double)this.tolerance);
        Assert.assertEquals((String)"min", (double)this.min, (double)u.getMin(), (double)this.tolerance);
        Assert.assertEquals((String)"max", (double)this.max, (double)u.getMax(), (double)this.tolerance);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)this.tolerance);
    }

    @Test
    public void testN0andN1Conditions() {
        ListUnivariateImpl u = new ListUnivariateImpl(new ArrayList<Object>(), (NumberTransformer)this.transformers);
        Assert.assertTrue((String)"Mean of n = 0 set should be NaN", (boolean)Double.isNaN(u.getMean()));
        Assert.assertTrue((String)"Standard Deviation of n = 0 set should be NaN", (boolean)Double.isNaN(u.getStandardDeviation()));
        Assert.assertTrue((String)"Variance of n = 0 set should be NaN", (boolean)Double.isNaN(u.getVariance()));
        u.addValue(this.one);
        Assert.assertTrue((String)("Mean of n = 1 set should be value of single item n1, instead it is " + u.getMean()), (u.getMean() == this.one ? 1 : 0) != 0);
        Assert.assertTrue((String)("StdDev of n = 1 set should be zero, instead it is: " + u.getStandardDeviation()), (u.getStandardDeviation() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Variance of n = 1 set should be zero", (u.getVariance() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSkewAndKurtosis() {
        ListUnivariateImpl u = new ListUnivariateImpl(new ArrayList<Object>(), (NumberTransformer)this.transformers);
        u.addObject("12.5");
        u.addObject(12);
        u.addObject("11.8");
        u.addObject("14.2");
        u.addObject(new Foo());
        u.addObject("14.5");
        u.addObject(21L);
        u.addObject("8.2");
        u.addObject("10.3");
        u.addObject("11.3");
        u.addObject(Float.valueOf(14.1f));
        u.addObject("9.9");
        u.addObject("12.2");
        u.addObject(new Bar());
        u.addObject("12.1");
        u.addObject("11");
        u.addObject(19.8);
        u.addObject("11");
        u.addObject("10");
        u.addObject("8.8");
        u.addObject("9");
        u.addObject("12.3");
        Assert.assertEquals((String)"mean", (double)12.40455, (double)u.getMean(), (double)1.0E-4);
        Assert.assertEquals((String)"variance", (double)10.00236, (double)u.getVariance(), (double)1.0E-4);
        Assert.assertEquals((String)"skewness", (double)1.437424, (double)u.getSkewness(), (double)1.0E-4);
        Assert.assertEquals((String)"kurtosis", (double)2.37719, (double)u.getKurtosis(), (double)1.0E-4);
    }

    @Test
    public void testProductAndGeometricMean() {
        ListUnivariateImpl u = new ListUnivariateImpl(new ArrayList<Object>(), (NumberTransformer)this.transformers);
        u.setWindowSize(10);
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(3.0);
        u.addValue(4.0);
        Assert.assertEquals((String)"Geometric mean not expected", (double)2.213364, (double)u.getGeometricMean(), (double)1.0E-5);
        for (int i = 0; i < 10; ++i) {
            u.addValue(i + 2);
        }
        Assert.assertEquals((String)"Geometric mean not expected", (double)5.755931, (double)u.getGeometricMean(), (double)1.0E-5);
    }

    public static final class BarTransformer
    implements NumberTransformer,
    Serializable {
        private static final long serialVersionUID = -1768345377764262043L;

        public double transform(Object o) {
            return Double.parseDouble(((Bar)o).heresBar());
        }
    }

    public static final class Bar {
        public String heresBar() {
            return "12.0";
        }
    }

    public static final class FooTransformer
    implements NumberTransformer,
    Serializable {
        private static final long serialVersionUID = -4252248129291326127L;

        public double transform(Object o) {
            return Double.parseDouble(((Foo)o).heresFoo());
        }
    }

    public static final class Foo {
        public String heresFoo() {
            return "14.9";
        }
    }
}

