/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.direct;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.LeastSquaresConverter;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.AbstractSimplex;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.NelderMeadSimplex;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.SimplexOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class SimplexOptimizerNelderMeadTest {
    @Test
    public void testMinimize1() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{0.2, 0.2}));
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(100, (MultivariateFunction)fourExtrema, GoalType.MINIMIZE, new double[]{-3.0, 0.0});
        Assert.assertEquals((double)fourExtrema.xM, (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)fourExtrema.yP, (double)optimum.getPoint()[1], (double)2.0E-5);
        Assert.assertEquals((double)fourExtrema.valueXmYp, (double)((Double)optimum.getValue()), (double)6.0E-12);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 90 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimize2() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{0.2, 0.2}));
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(100, (MultivariateFunction)fourExtrema, GoalType.MINIMIZE, new double[]{1.0, 0.0});
        Assert.assertEquals((double)fourExtrema.xP, (double)optimum.getPoint()[0], (double)5.0E-6);
        Assert.assertEquals((double)fourExtrema.yM, (double)optimum.getPoint()[1], (double)6.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXpYm, (double)((Double)optimum.getValue()), (double)1.0E-11);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 90 ? 1 : 0) != 0);
    }

    @Test
    public void testMaximize1() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{0.2, 0.2}));
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(100, (MultivariateFunction)fourExtrema, GoalType.MAXIMIZE, new double[]{-3.0, 0.0});
        Assert.assertEquals((double)fourExtrema.xM, (double)optimum.getPoint()[0], (double)1.0E-5);
        Assert.assertEquals((double)fourExtrema.yM, (double)optimum.getPoint()[1], (double)3.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXmYm, (double)((Double)optimum.getValue()), (double)3.0E-12);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 90 ? 1 : 0) != 0);
    }

    @Test
    public void testMaximize2() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{0.2, 0.2}));
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(100, (MultivariateFunction)fourExtrema, GoalType.MAXIMIZE, new double[]{1.0, 0.0});
        Assert.assertEquals((double)fourExtrema.xP, (double)optimum.getPoint()[0], (double)4.0E-6);
        Assert.assertEquals((double)fourExtrema.yP, (double)optimum.getPoint()[1], (double)5.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXpYp, (double)((Double)optimum.getValue()), (double)7.0E-12);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 90 ? 1 : 0) != 0);
    }

    @Test
    public void testRosenbrock() {
        Rosenbrock rosenbrock = new Rosenbrock();
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 0.001);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex((double[][])new double[][]{{-1.2, 1.0}, {0.9, 1.2}, {3.5, -2.3}}));
        PointValuePair optimum = optimizer.optimize(100, (MultivariateFunction)rosenbrock, GoalType.MINIMIZE, new double[]{-1.2, 1.0});
        Assert.assertEquals((long)rosenbrock.getCount(), (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 40 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 50 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 8.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testPowell() {
        Powell powell = new Powell();
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 0.001);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(4));
        PointValuePair optimum = optimizer.optimize(200, (MultivariateFunction)powell, GoalType.MINIMIZE, new double[]{3.0, -1.0, 0.0, 1.0});
        Assert.assertEquals((long)powell.getCount(), (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 110 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 130 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 0.002 ? 1 : 0) != 0);
    }

    @Test
    public void testLeastSquares1() {
        Array2DRowRealMatrix factors = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}}, false);
        LeastSquaresConverter ls = new LeastSquaresConverter(new MultivariateVectorFunction((RealMatrix)factors){
            final /* synthetic */ RealMatrix val$factors;
            {
                this.val$factors = realMatrix;
            }

            public double[] value(double[] variables) {
                return this.val$factors.operate(variables);
            }
        }, new double[]{2.0, -3.0});
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 1.0E-6);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(2));
        PointValuePair optimum = optimizer.optimize(200, (MultivariateFunction)ls, GoalType.MINIMIZE, new double[]{10.0, 10.0});
        Assert.assertEquals((double)2.0, (double)optimum.getPointRef()[0], (double)3.0E-5);
        Assert.assertEquals((double)-3.0, (double)optimum.getPointRef()[1], (double)4.0E-4);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 80 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testLeastSquares2() {
        Array2DRowRealMatrix factors = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}}, false);
        LeastSquaresConverter ls = new LeastSquaresConverter(new MultivariateVectorFunction((RealMatrix)factors){
            final /* synthetic */ RealMatrix val$factors;
            {
                this.val$factors = realMatrix;
            }

            public double[] value(double[] variables) {
                return this.val$factors.operate(variables);
            }
        }, new double[]{2.0, -3.0}, new double[]{10.0, 0.1});
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 1.0E-6);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(2));
        PointValuePair optimum = optimizer.optimize(200, (MultivariateFunction)ls, GoalType.MINIMIZE, new double[]{10.0, 10.0});
        Assert.assertEquals((double)2.0, (double)optimum.getPointRef()[0], (double)5.0E-5);
        Assert.assertEquals((double)-3.0, (double)optimum.getPointRef()[1], (double)8.0E-4);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 80 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testLeastSquares3() {
        Array2DRowRealMatrix factors = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}}, false);
        LeastSquaresConverter ls = new LeastSquaresConverter(new MultivariateVectorFunction((RealMatrix)factors){
            final /* synthetic */ RealMatrix val$factors;
            {
                this.val$factors = realMatrix;
            }

            public double[] value(double[] variables) {
                return this.val$factors.operate(variables);
            }
        }, new double[]{2.0, -3.0}, (RealMatrix)new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 1.2}, {1.2, 2.0}}));
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 1.0E-6);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(2));
        PointValuePair optimum = optimizer.optimize(200, (MultivariateFunction)ls, GoalType.MINIMIZE, new double[]{10.0, 10.0});
        Assert.assertEquals((double)2.0, (double)optimum.getPointRef()[0], (double)0.002);
        Assert.assertEquals((double)-3.0, (double)optimum.getPointRef()[1], (double)8.0E-4);
        Assert.assertTrue((optimizer.getEvaluations() > 60 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 80 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test(expected=TooManyEvaluationsException.class)
    public void testMaxIterations() {
        Powell powell = new Powell();
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 0.001);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(4));
        optimizer.optimize(20, (MultivariateFunction)powell, GoalType.MINIMIZE, new double[]{3.0, -1.0, 0.0, 1.0});
    }

    private static class Powell
    implements MultivariateFunction {
        private int count = 0;

        public double value(double[] x) {
            ++this.count;
            double a = x[0] + 10.0 * x[1];
            double b = x[2] - x[3];
            double c = x[1] - 2.0 * x[2];
            double d = x[0] - x[3];
            return a * a + 5.0 * b * b + c * c * c * c + 10.0 * d * d * d * d;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class Rosenbrock
    implements MultivariateFunction {
        private int count = 0;

        public double value(double[] x) {
            ++this.count;
            double a = x[1] - x[0] * x[0];
            double b = 1.0 - x[0];
            return 100.0 * a * a + b * b;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class FourExtrema
    implements MultivariateFunction {
        final double xM = -3.841947088256864;
        final double yM = -1.391745200270735;
        final double xP = 0.22866822373490592;
        final double yP = 1.391745200270735;
        final double valueXmYm = 0.2373295333134217;
        final double valueXmYp = -0.2373295333134217;
        final double valueXpYm = -0.7290400707055187;
        final double valueXpYp = 0.7290400707055187;

        private FourExtrema() {
        }

        public double value(double[] variables) {
            double x = variables[0];
            double y = variables[1];
            return x == 0.0 || y == 0.0 ? 0.0 : FastMath.atan((double)x) * FastMath.atan((double)(x + 2.0)) * FastMath.atan((double)y) * FastMath.atan((double)y) / (x * y);
        }
    }
}

