/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim.univariate;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.optim.MaxEval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.OptimizationData;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.BrentOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.MultiStartUnivariateOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.SearchInterval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class MultiStartUnivariateOptimizerTest {
    @Test(expected=MathIllegalStateException.class)
    public void testMissingMaxEval() {
        BrentOptimizer underlying = new BrentOptimizer(1.0E-10, 1.0E-14);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(44428400075L);
        MultiStartUnivariateOptimizer optimizer = new MultiStartUnivariateOptimizer((UnivariateOptimizer)underlying, 10, (RandomGenerator)g);
        optimizer.optimize(new OptimizationData[]{new UnivariateObjectiveFunction((UnivariateFunction)new Sin()), GoalType.MINIMIZE, new SearchInterval(-1.0, 1.0)});
    }

    @Test(expected=MathIllegalStateException.class)
    public void testMissingSearchInterval() {
        BrentOptimizer underlying = new BrentOptimizer(1.0E-10, 1.0E-14);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(44428400075L);
        MultiStartUnivariateOptimizer optimizer = new MultiStartUnivariateOptimizer((UnivariateOptimizer)underlying, 10, (RandomGenerator)g);
        optimizer.optimize(new OptimizationData[]{new MaxEval(300), new UnivariateObjectiveFunction((UnivariateFunction)new Sin()), GoalType.MINIMIZE});
    }

    @Test
    public void testSinMin() {
        Sin f = new Sin();
        BrentOptimizer underlying = new BrentOptimizer(1.0E-10, 1.0E-14);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(44428400075L);
        MultiStartUnivariateOptimizer optimizer = new MultiStartUnivariateOptimizer((UnivariateOptimizer)underlying, 10, (RandomGenerator)g);
        optimizer.optimize(new OptimizationData[]{new MaxEval(300), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(-100.0, 100.0)});
        UnivariatePointValuePair[] optima = optimizer.getOptima();
        for (int i = 1; i < optima.length; ++i) {
            double d = (optima[i].getPoint() - optima[i - 1].getPoint()) / (Math.PI * 2);
            Assert.assertTrue((FastMath.abs((double)(d - FastMath.rint((double)d))) < 1.0E-8 ? 1 : 0) != 0);
            Assert.assertEquals((double)-1.0, (double)f.value(optima[i].getPoint()), (double)1.0E-10);
            Assert.assertEquals((double)f.value(optima[i].getPoint()), (double)optima[i].getValue(), (double)1.0E-10);
        }
        Assert.assertTrue((optimizer.getEvaluations() > 200 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 300 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticMin() {
        QuinticFunction f = new QuinticFunction();
        BrentOptimizer underlying = new BrentOptimizer(1.0E-9, 1.0E-14);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(4312000053L);
        MultiStartUnivariateOptimizer optimizer = new MultiStartUnivariateOptimizer((UnivariateOptimizer)underlying, 5, (RandomGenerator)g);
        UnivariatePointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(300), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(-0.3, -0.2)});
        Assert.assertEquals((double)-0.27195613, (double)optimum.getPoint(), (double)1.0E-9);
        Assert.assertEquals((double)-0.0443342695, (double)optimum.getValue(), (double)1.0E-9);
        UnivariatePointValuePair[] optima = optimizer.getOptima();
        for (int i = 0; i < optima.length; ++i) {
            Assert.assertEquals((double)f.value(optima[i].getPoint()), (double)optima[i].getValue(), (double)1.0E-9);
        }
        Assert.assertTrue((optimizer.getEvaluations() >= 50 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() <= 100 ? 1 : 0) != 0);
    }

    @Test
    public void testBadFunction() {
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                if (x < 0.0) {
                    throw new LocalException();
                }
                return 0.0;
            }
        };
        BrentOptimizer underlying = new BrentOptimizer(1.0E-9, 1.0E-14);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(4312000053L);
        MultiStartUnivariateOptimizer optimizer = new MultiStartUnivariateOptimizer((UnivariateOptimizer)underlying, 5, (RandomGenerator)g);
        try {
            optimizer.optimize(new OptimizationData[]{new MaxEval(300), new UnivariateObjectiveFunction(f), GoalType.MINIMIZE, new SearchInterval(-0.3, -0.2)});
            Assert.fail();
        }
        catch (LocalException localException) {
            // empty catch block
        }
        Assert.assertTrue((optimizer.getOptima()[0] == null ? 1 : 0) != 0);
    }

    private static class LocalException
    extends RuntimeException {
        private static final long serialVersionUID = 1194682757034350629L;

        private LocalException() {
        }
    }
}

