/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim.univariate;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.FunctionUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.StepFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.MaxEval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.OptimizationData;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.BrentOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.SearchInterval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.SimpleUnivariateValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class BrentOptimizerTest {
    @Test
    public void testSinMin() {
        Sin f = new Sin();
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-10, 1.0E-14);
        Assert.assertEquals((double)4.71238898038469, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(4.0, 5.0)}).getPoint(), (double)1.0E-8);
        Assert.assertTrue((optimizer.getEvaluations() <= 50 ? 1 : 0) != 0);
        Assert.assertEquals((long)200L, (long)optimizer.getMaxEvaluations());
        Assert.assertEquals((double)4.71238898038469, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(1.0, 5.0)}).getPoint(), (double)1.0E-8);
        Assert.assertTrue((optimizer.getEvaluations() <= 100 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() >= 15 ? 1 : 0) != 0);
        try {
            optimizer.optimize(new OptimizationData[]{new MaxEval(10), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(4.0, 5.0)});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testSinMinWithValueChecker() {
        Sin f = new Sin();
        SimpleUnivariateValueChecker checker = new SimpleUnivariateValueChecker(1.0E-5, 1.0E-14);
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-10, 1.0E-14, (ConvergenceChecker)checker);
        UnivariatePointValuePair result = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(4.0, 5.0)});
        Assert.assertEquals((double)4.71238898038469, (double)result.getPoint(), (double)0.001);
    }

    @Test
    public void testBoundaries() {
        double lower = -1.0;
        double upper = 1.0;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                if (x < -1.0) {
                    throw new NumberIsTooSmallException((Number)x, (Number)-1.0, true);
                }
                if (x > 1.0) {
                    throw new NumberIsTooLargeException((Number)x, (Number)1.0, true);
                }
                return x;
            }
        };
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-10, 1.0E-14);
        Assert.assertEquals((double)-1.0, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(100), new UnivariateObjectiveFunction(f), GoalType.MINIMIZE, new SearchInterval(-1.0, 1.0)}).getPoint(), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(100), new UnivariateObjectiveFunction(f), GoalType.MAXIMIZE, new SearchInterval(-1.0, 1.0)}).getPoint(), (double)1.0E-8);
    }

    @Test
    public void testQuinticMin() {
        QuinticFunction f = new QuinticFunction();
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-10, 1.0E-14);
        Assert.assertEquals((double)-0.27195613, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(-0.3, -0.2)}).getPoint(), (double)1.0E-8);
        Assert.assertEquals((double)0.82221643, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(0.3, 0.9)}).getPoint(), (double)1.0E-8);
        Assert.assertTrue((optimizer.getEvaluations() <= 50 ? 1 : 0) != 0);
        Assert.assertEquals((double)-0.27195613, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(-1.0, 0.2)}).getPoint(), (double)1.0E-8);
        Assert.assertTrue((optimizer.getEvaluations() <= 50 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticMinStatistics() {
        QuinticFunction f = new QuinticFunction();
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-11, 1.0E-14);
        DescriptiveStatistics[] stat = new DescriptiveStatistics[2];
        for (int i = 0; i < stat.length; ++i) {
            stat[i] = new DescriptiveStatistics();
        }
        double min = -0.75;
        double max = 0.25;
        int nSamples = 200;
        double delta = 0.005;
        for (int i = 0; i < 200; ++i) {
            double start = -0.75 + (double)i * 0.005;
            stat[0].addValue(optimizer.optimize(new OptimizationData[]{new MaxEval(40), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(-0.75, 0.25, start)}).getPoint());
            stat[1].addValue((double)optimizer.getEvaluations());
        }
        double meanOptValue = stat[0].getMean();
        double medianEval = stat[1].getPercentile(50.0);
        Assert.assertTrue((meanOptValue > -0.2719561281 ? 1 : 0) != 0);
        Assert.assertTrue((meanOptValue < -0.271956128 ? 1 : 0) != 0);
        Assert.assertEquals((long)23L, (long)((int)medianEval));
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticMax() {
        QuinticFunction f = new QuinticFunction();
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-12, 1.0E-14);
        Assert.assertEquals((double)0.27195613, (double)optimizer.optimize(new OptimizationData[]{new MaxEval(100), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MAXIMIZE, new SearchInterval(0.2, 0.3)}).getPoint(), (double)1.0E-8);
        try {
            optimizer.optimize(new OptimizationData[]{new MaxEval(5), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MAXIMIZE, new SearchInterval(0.2, 0.3)});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testMinEndpoints() {
        Sin f = new Sin();
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-8, 1.0E-14);
        double result = optimizer.optimize(new OptimizationData[]{new MaxEval(50), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(4.71238898038469, 5.0)}).getPoint();
        Assert.assertEquals((double)4.71238898038469, (double)result, (double)1.0E-6);
        result = optimizer.optimize(new OptimizationData[]{new MaxEval(50), new UnivariateObjectiveFunction((UnivariateFunction)f), GoalType.MINIMIZE, new SearchInterval(4.0, 4.71238898038469)}).getPoint();
        Assert.assertEquals((double)4.71238898038469, (double)result, (double)1.0E-6);
    }

    @Test
    public void testMath832() {
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                double sqrtX = FastMath.sqrt((double)x);
                double a = 100.0 * sqrtX;
                double b = 1000000.0 / x;
                double c = 10000.0 / sqrtX;
                return a + b + c;
            }
        };
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-10, 1.0E-8);
        double result = optimizer.optimize(new OptimizationData[]{new MaxEval(1483), new UnivariateObjectiveFunction(f), GoalType.MINIMIZE, new SearchInterval(Double.MIN_VALUE, Double.MAX_VALUE)}).getPoint();
        Assert.assertEquals((double)804.9355825, (double)result, (double)1.0E-6);
    }

    @Test
    public void testKeepInitIfBest() {
        double minSin = 4.71238898038469;
        double offset = 1.0E-8;
        double delta = 1.0E-7;
        Sin f1 = new Sin();
        StepFunction f2 = new StepFunction(new double[]{4.71238898038469, 4.71238899038469, 4.7123890003846896}, new double[]{0.0, -1.0, 0.0});
        UnivariateFunction f = FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{f1, f2});
        double relTol = 1.0E-8;
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-8, 1.0E-100);
        double init = 4.71238899538469;
        UnivariatePointValuePair result = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction(f), GoalType.MINIMIZE, new SearchInterval(4.7123883014846895, 4.71238996798469, 4.71238899538469)});
        double sol = result.getPoint();
        double expected = 4.71238899538469;
        Assert.assertTrue((String)"Best point not reported", (f.value(sol) <= f.value(4.71238899538469) ? 1 : 0) != 0);
    }

    @Test
    public void testMath855() {
        double minSin = 4.71238898038469;
        double offset = 1.0E-8;
        double delta = 1.0E-7;
        Sin f1 = new Sin();
        StepFunction f2 = new StepFunction(new double[]{4.71238898038469, 4.71238899038469, 4.712389030384689}, new double[]{0.0, -1.0, 0.0});
        UnivariateFunction f = FunctionUtils.add((UnivariateFunction[])new UnivariateFunction[]{f1, f2});
        BrentOptimizer optimizer = new BrentOptimizer(1.0E-8, 1.0E-100);
        UnivariatePointValuePair result = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new UnivariateObjectiveFunction(f), GoalType.MINIMIZE, new SearchInterval(4.7123883014846895, 4.71238996798469)});
        double sol = result.getPoint();
        double expected = 4.712389027602411;
        Assert.assertTrue((String)"Best point not reported", (f.value(sol) <= f.value(4.712389027602411) ? 1 : 0) != 0);
    }
}

