/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.InitialGuess;
import com.hazelcast.shaded.org.apache.commons.math3.optim.MaxEval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.OptimizationData;
import com.hazelcast.shaded.org.apache.commons.math3.optim.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optim.SimpleValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.MultiStartMultivariateOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.gradient.CircleScalar;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.random.GaussianRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.NormalizedRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomVectorGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.junit.Assert;
import org.junit.Test;

public class MultiStartMultivariateOptimizerTest {
    @Test
    public void testCircleFitting() {
        CircleScalar circle = new CircleScalar();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        NonLinearConjugateGradientOptimizer underlying = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-10, 1.0E-10));
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(753289573253L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(new double[]{50.0, 50.0}, new double[]{10.0, 10.0}, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        int nbStarts = 10;
        MultiStartMultivariateOptimizer optimizer = new MultiStartMultivariateOptimizer((MultivariateOptimizer)underlying, nbStarts, (RandomVectorGenerator)generator);
        PointValuePair optimum = (PointValuePair)optimizer.optimize(new OptimizationData[]{new MaxEval(1000), circle.getObjectiveFunction(), circle.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{98.68, 47.345})});
        Assert.assertEquals((long)1000L, (long)optimizer.getMaxEvaluations());
        PointValuePair[] optima = optimizer.getOptima();
        Assert.assertEquals((long)nbStarts, (long)optima.length);
        for (PointValuePair o : optima) {
            Vector2D center = new Vector2D(o.getPointRef()[0], o.getPointRef()[1]);
            Assert.assertTrue((69.9592 < circle.getRadius(center) ? 1 : 0) != 0);
            Assert.assertTrue((69.9602 > circle.getRadius(center) ? 1 : 0) != 0);
            Assert.assertTrue((96.0745 < center.getX() ? 1 : 0) != 0);
            Assert.assertTrue((96.0762 > center.getX() ? 1 : 0) != 0);
            Assert.assertTrue((48.1344 < center.getY() ? 1 : 0) != 0);
            Assert.assertTrue((48.1354 > center.getY() ? 1 : 0) != 0);
        }
        Assert.assertTrue((optimizer.getEvaluations() > 850 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 900 ? 1 : 0) != 0);
        Assert.assertEquals((double)3.1267527, (double)((Double)optimum.getValue()), (double)1.0E-8);
    }

    @Test
    public void testRosenbrock() {
        Rosenbrock rosenbrock = new Rosenbrock();
        SimplexOptimizer underlying = new SimplexOptimizer((ConvergenceChecker)new SimpleValueChecker(-1.0, 0.001));
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{{-1.2, 1.0}, {0.9, 1.2}, {3.5, -2.3}});
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(2, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        int nbStarts = 10;
        MultiStartMultivariateOptimizer optimizer = new MultiStartMultivariateOptimizer((MultivariateOptimizer)underlying, nbStarts, (RandomVectorGenerator)generator);
        PointValuePair optimum = (PointValuePair)optimizer.optimize(new OptimizationData[]{new MaxEval(1100), new ObjectiveFunction((MultivariateFunction)rosenbrock), GoalType.MINIMIZE, simplex, new InitialGuess(new double[]{-1.2, 1.0})});
        Assert.assertEquals((long)nbStarts, (long)optimizer.getOptima().length);
        Assert.assertEquals((long)rosenbrock.getCount(), (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 900 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 1200 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 5.0E-5 ? 1 : 0) != 0);
    }

    private static class Rosenbrock
    implements MultivariateFunction {
        private int count = 0;

        public double value(double[] x) {
            ++this.count;
            double a = x[1] - x[0] * x[0];
            double b = 1.0 - x[0];
            return 100.0 * a * a + b * b;
        }

        public int getCount() {
            return this.count;
        }
    }
}

