/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldExpandableODE;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEState;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem2;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem4;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem5;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblem6;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestFieldProblemHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.Action;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.FieldEventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.StepFieldProblem;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.FieldStepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolatorTestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import java.lang.reflect.Array;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RungeKuttaFieldIntegratorAbstractTest {
    protected abstract <T extends RealFieldElement<T>> RungeKuttaFieldIntegrator<T> createIntegrator(Field<T> var1, T var2);

    @Test
    public abstract void testNonFieldIntegratorConsistency();

    protected <T extends RealFieldElement<T>> void doTestNonFieldIntegratorConsistency(Field<T> field) {
        try {
            RungeKuttaFieldIntegrator<RealFieldElement> fieldIntegrator = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0));
            RealFieldElement[][] fieldA = fieldIntegrator.getA();
            RealFieldElement[] fieldB = fieldIntegrator.getB();
            RealFieldElement[] fieldC = fieldIntegrator.getC();
            String fieldName = fieldIntegrator.getClass().getName();
            String regularName = fieldName.replaceAll("Field", "");
            Class<?> c = Class.forName(regularName);
            java.lang.reflect.Field jlrFieldA = c.getDeclaredField("STATIC_A");
            jlrFieldA.setAccessible(true);
            double[][] regularA = (double[][])jlrFieldA.get(null);
            java.lang.reflect.Field jlrFieldB = c.getDeclaredField("STATIC_B");
            jlrFieldB.setAccessible(true);
            double[] regularB = (double[])jlrFieldB.get(null);
            java.lang.reflect.Field jlrFieldC = c.getDeclaredField("STATIC_C");
            jlrFieldC.setAccessible(true);
            double[] regularC = (double[])jlrFieldC.get(null);
            Assert.assertEquals((long)regularA.length, (long)fieldA.length);
            for (int i = 0; i < regularA.length; ++i) {
                this.checkArray(regularA[i], fieldA[i]);
            }
            this.checkArray(regularB, fieldB);
            this.checkArray(regularC, fieldC);
        }
        catch (ClassNotFoundException cnfe) {
            Assert.fail((String)cnfe.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)iae.getLocalizedMessage());
        }
        catch (SecurityException se) {
            Assert.fail((String)se.getLocalizedMessage());
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)nsfe.getLocalizedMessage());
        }
    }

    private <T extends RealFieldElement<T>> void checkArray(double[] regularArray, T[] fieldArray) {
        Assert.assertEquals((long)regularArray.length, (long)fieldArray.length);
        for (int i = 0; i < regularArray.length; ++i) {
            if (regularArray[i] == 0.0) {
                Assert.assertTrue((0.0 == fieldArray[i].getReal() ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((double)regularArray[i], (double)fieldArray[i].getReal(), (double)FastMath.ulp((double)regularArray[i]));
        }
    }

    @Test
    public abstract void testMissedEndEvent();

    protected <T extends RealFieldElement<T>> void doTestMissedEndEvent(final Field<T> field, final double epsilonT, double epsilonY) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int i;
        RealFieldElement t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.8782503200000029E9);
        final RealFieldElement tEvent = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.8782503799999986E9);
        final RealFieldElement[] k = (RealFieldElement[])MathArrays.buildArray(field, (int)3);
        k[0] = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-4);
        k[1] = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-5);
        k[2] = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0E-6);
        FirstOrderFieldDifferentialEquations ode = new FirstOrderFieldDifferentialEquations<T>(){

            public int getDimension() {
                return k.length;
            }

            public void init(T t0, T[] y0, T t) {
            }

            public T[] computeDerivatives(T t, T[] y) {
                RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)k.length);
                for (int i = 0; i < y.length; ++i) {
                    yDot[i] = (RealFieldElement)k[i].multiply(y[i]);
                }
                return yDot;
            }
        };
        RungeKuttaFieldIntegrator<RealFieldElement> integrator = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(60.0));
        RealFieldElement[] y0 = (RealFieldElement[])MathArrays.buildArray(field, (int)k.length);
        for (int i2 = 0; i2 < y0.length; ++i2) {
            y0[i2] = (RealFieldElement)((RealFieldElement)field.getOne()).add((double)i2);
        }
        FieldODEStateAndDerivative result = integrator.integrate(new FieldExpandableODE(ode), new FieldODEState(t0, y0), tEvent);
        Assert.assertEquals((double)tEvent.getReal(), (double)result.getTime().getReal(), (double)epsilonT);
        RealFieldElement[] y = result.getState();
        for (i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)((RealFieldElement)y0[i].multiply(((RealFieldElement)k[i].multiply(result.getTime().subtract((Object)t0))).exp())).getReal(), (double)y[i].getReal(), (double)epsilonY);
        }
        integrator.addEventHandler(new FieldEventHandler<T>(){

            public void init(FieldODEStateAndDerivative<T> state0, T t) {
            }

            public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
                return state;
            }

            public T g(FieldODEStateAndDerivative<T> state) {
                return (RealFieldElement)state.getTime().subtract((Object)tEvent);
            }

            public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
                Assert.assertEquals((double)tEvent.getReal(), (double)state.getTime().getReal(), (double)epsilonT);
                return Action.CONTINUE;
            }
        }, Double.POSITIVE_INFINITY, 1.0E-20, 100);
        result = integrator.integrate(new FieldExpandableODE(ode), new FieldODEState(t0, y0), (RealFieldElement)tEvent.add(120.0));
        Assert.assertEquals((double)((RealFieldElement)tEvent.add(120.0)).getReal(), (double)result.getTime().getReal(), (double)epsilonT);
        y = result.getState();
        for (i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)((RealFieldElement)y0[i].multiply(((RealFieldElement)k[i].multiply(result.getTime().subtract((Object)t0))).exp())).getReal(), (double)y[i].getReal(), (double)epsilonY);
        }
    }

    @Test
    public abstract void testSanityChecks();

    protected <T extends RealFieldElement<T>> void doTestSanityChecks(Field<T> field) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem1<T> pb2;
        RungeKuttaFieldIntegrator<RealFieldElement> integrator = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.01));
        try {
            pb2 = new TestFieldProblem1<T>(field);
            integrator.integrate(new FieldExpandableODE(pb2), new FieldODEState((RealFieldElement)field.getZero(), (RealFieldElement[])MathArrays.buildArray(field, (int)(pb2.getDimension() + 10))), (RealFieldElement)field.getOne());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException pb2) {
            // empty catch block
        }
        try {
            pb2 = new TestFieldProblem1<T>(field);
            integrator.integrate(new FieldExpandableODE(pb2), new FieldODEState((RealFieldElement)field.getZero(), (RealFieldElement[])MathArrays.buildArray(field, (int)pb2.getDimension())), (RealFieldElement)field.getZero());
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public abstract void testDecreasingSteps();

    protected <T extends RealFieldElement<T>> void doTestDecreasingSteps(Field<T> field, double safetyValueFactor, double safetyTimeFactor, double epsilonT) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblemAbstract[] allProblems = (TestFieldProblemAbstract[])Array.newInstance(TestFieldProblemAbstract.class, 6);
        allProblems[0] = new TestFieldProblem1<T>(field);
        allProblems[1] = new TestFieldProblem2<T>(field);
        allProblems[2] = new TestFieldProblem3<T>(field);
        allProblems[3] = new TestFieldProblem4<T>(field);
        allProblems[4] = new TestFieldProblem5<T>(field);
        allProblems[5] = new TestFieldProblem6<T>(field);
        for (TestFieldProblemAbstract pb : allProblems) {
            RealFieldElement previousValueError = null;
            RealFieldElement previousTimeError = null;
            for (int i = 4; i < 10; ++i) {
                RealFieldElement step = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(FastMath.pow((double)2.0, (int)(-i)));
                RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
                TestFieldProblemHandler<RealFieldElement> handler = new TestFieldProblemHandler<RealFieldElement>(pb, (FirstOrderFieldIntegrator<RealFieldElement>)integ);
                integ.addStepHandler(handler);
                FieldEventHandler<T>[] functions = pb.getEventsHandlers();
                for (int l = 0; l < functions.length; ++l) {
                    integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, 1.0E-6 * step.getReal(), 1000);
                }
                Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
                FieldODEStateAndDerivative stop = integ.integrate(new FieldExpandableODE((FirstOrderFieldDifferentialEquations)pb), pb.getInitialState(), pb.getFinalTime());
                if (functions.length == 0) {
                    Assert.assertEquals((double)pb.getFinalTime().getReal(), (double)stop.getTime().getReal(), (double)epsilonT);
                }
                RealFieldElement error = handler.getMaximalValueError();
                if (i > 4) {
                    Assert.assertTrue((((RealFieldElement)error.subtract(((RealFieldElement)previousValueError.abs()).multiply(safetyValueFactor))).getReal() < 0.0 ? 1 : 0) != 0);
                }
                previousValueError = error;
                RealFieldElement timeError = handler.getMaximalTimeError();
                if (i > 4) {
                    Assert.assertTrue((((RealFieldElement)timeError.subtract(((RealFieldElement)previousTimeError.abs()).multiply(safetyTimeFactor))).getReal() <= 0.0 ? 1 : 0) != 0);
                }
                previousTimeError = timeError;
                integ.clearEventHandlers();
                Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
            }
        }
    }

    @Test
    public abstract void testSmallStep();

    protected <T extends RealFieldElement<T>> void doTestSmallStep(Field<T> field, double epsilonLast, double epsilonMaxValue, double epsilonMaxTime, String name) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        RealFieldElement step = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.001);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        TestFieldProblemHandler<RealFieldElement> handler = new TestFieldProblemHandler<RealFieldElement>((TestFieldProblemAbstract<RealFieldElement>)pb, (FirstOrderFieldIntegrator<RealFieldElement>)integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertEquals((double)0.0, (double)handler.getLastError().getReal(), (double)epsilonLast);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError().getReal(), (double)epsilonMaxValue);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilonMaxTime);
        Assert.assertEquals((Object)name, (Object)integ.getName());
    }

    @Test
    public abstract void testBigStep();

    protected <T extends RealFieldElement<T>> void doTestBigStep(Field<T> field, double belowLast, double belowMaxValue, double epsilonMaxTime, String name) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem1<T> pb = new TestFieldProblem1<T>(field);
        RealFieldElement step = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.2);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        TestFieldProblemHandler<RealFieldElement> handler = new TestFieldProblemHandler<RealFieldElement>((TestFieldProblemAbstract<RealFieldElement>)pb, (FirstOrderFieldIntegrator<RealFieldElement>)integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertTrue((handler.getLastError().getReal() > belowLast ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError().getReal() > belowMaxValue ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilonMaxTime);
        Assert.assertEquals((Object)name, (Object)integ.getName());
    }

    @Test
    public abstract void testBackward();

    protected <T extends RealFieldElement<T>> void doTestBackward(Field<T> field, double epsilonLast, double epsilonMaxValue, double epsilonMaxTime, String name) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem5<T> pb = new TestFieldProblem5<T>(field);
        RealFieldElement step = (RealFieldElement)((RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.001)).abs();
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        TestFieldProblemHandler<RealFieldElement> handler = new TestFieldProblemHandler<RealFieldElement>((TestFieldProblemAbstract<RealFieldElement>)pb, (FirstOrderFieldIntegrator<RealFieldElement>)integ);
        integ.addStepHandler(handler);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Assert.assertEquals((double)0.0, (double)handler.getLastError().getReal(), (double)epsilonLast);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError().getReal(), (double)epsilonMaxValue);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError().getReal(), (double)epsilonMaxTime);
        Assert.assertEquals((Object)name, (Object)integ.getName());
    }

    @Test
    public abstract void testKepler();

    protected <T extends RealFieldElement<T>> void doTestKepler(Field<T> field, double expectedMaxError, double epsilon) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestFieldProblem3<RealFieldElement> pb = new TestFieldProblem3<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        RealFieldElement step = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(3.0E-4);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        integ.addStepHandler(new KeplerHandler<RealFieldElement>(pb, expectedMaxError, epsilon));
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
    }

    @Test
    public abstract void testStepSize();

    protected <T extends RealFieldElement<T>> void doTestStepSize(Field<T> field, final double epsilon) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        final RealFieldElement step = (RealFieldElement)((RealFieldElement)field.getZero()).add(1.23456);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        integ.addStepHandler(new FieldStepHandler<T>(){

            public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) {
                if (!isLast) {
                    Assert.assertEquals((double)step.getReal(), (double)((RealFieldElement)interpolator.getCurrentState().getTime().subtract((Object)interpolator.getPreviousState().getTime())).getReal(), (double)epsilon);
                }
            }

            public void init(FieldODEStateAndDerivative<T> s0, T t) {
            }
        });
        integ.integrate(new FieldExpandableODE(new FirstOrderFieldDifferentialEquations<T>(){

            public void init(T t0, T[] y0, T t) {
            }

            public T[] computeDerivatives(T t, T[] y) {
                RealFieldElement[] dot = (RealFieldElement[])MathArrays.buildArray((Field)t.getField(), (int)1);
                dot[0] = (RealFieldElement)t.getField().getOne();
                return dot;
            }

            public int getDimension() {
                return 1;
            }
        }), new FieldODEState((RealFieldElement)field.getZero(), (RealFieldElement[])MathArrays.buildArray(field, (int)1)), (RealFieldElement)((RealFieldElement)field.getZero()).add(5.0));
    }

    @Test
    public abstract void testSingleStep();

    protected <T extends RealFieldElement<T>> void doTestSingleStep(Field<T> field, double epsilon) {
        TestFieldProblem3<RealFieldElement> pb = new TestFieldProblem3<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        RealFieldElement h = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(3.0E-4);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(Double.NaN));
        RealFieldElement t = pb.getInitialState().getTime();
        RealFieldElement[] y = pb.getInitialState().getState();
        for (int i = 0; i < 100; ++i) {
            y = integ.singleStep(pb, t, y, (RealFieldElement)t.add((Object)h));
            t = (RealFieldElement)t.add((Object)h);
        }
        RealFieldElement[] yth = pb.computeTheoreticalState(t);
        RealFieldElement dx = (RealFieldElement)y[0].subtract((Object)yth[0]);
        RealFieldElement dy = (RealFieldElement)y[1].subtract((Object)yth[1]);
        RealFieldElement error = (RealFieldElement)((RealFieldElement)dx.multiply((Object)dx)).add(dy.multiply((Object)dy));
        Assert.assertEquals((double)0.0, (double)error.getReal(), (double)epsilon);
    }

    @Test
    public abstract void testTooLargeFirstStep();

    protected <T extends RealFieldElement<T>> void doTestTooLargeFirstStep(final Field<T> field) {
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.5));
        final RealFieldElement t0 = (RealFieldElement)field.getZero();
        RealFieldElement[] y0 = (RealFieldElement[])MathArrays.buildArray(field, (int)1);
        y0[0] = (RealFieldElement)field.getOne();
        RealFieldElement t = (RealFieldElement)((RealFieldElement)field.getZero()).add(0.001);
        FirstOrderFieldDifferentialEquations equations = new FirstOrderFieldDifferentialEquations<T>(){

            public int getDimension() {
                return 1;
            }

            public void init(T t02, T[] y0, T t) {
            }

            public T[] computeDerivatives(T t, T[] y) {
                Assert.assertTrue((t.getReal() >= FastMath.nextAfter((double)t0.getReal(), (double)Double.NEGATIVE_INFINITY) ? 1 : 0) != 0);
                Assert.assertTrue((t.getReal() <= FastMath.nextAfter((double)t.getReal(), (double)Double.POSITIVE_INFINITY) ? 1 : 0) != 0);
                RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)1);
                yDot[0] = (RealFieldElement)y[0].multiply(-100.0);
                return yDot;
            }
        };
        integ.integrate(new FieldExpandableODE(equations), new FieldODEState(t0, y0), t);
    }

    @Test
    public abstract void testUnstableDerivative();

    protected <T extends RealFieldElement<T>> void doTestUnstableDerivative(Field<T> field, double epsilon) {
        StepFieldProblem<RealFieldElement> stepProblem = new StepFieldProblem<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(1.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(2.0));
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.3));
        integ.addEventHandler(stepProblem, 1.0, 1.0E-12, 1000);
        FieldODEStateAndDerivative result = integ.integrate(new FieldExpandableODE(stepProblem), new FieldODEState((RealFieldElement)field.getZero(), (RealFieldElement[])MathArrays.buildArray(field, (int)1)), (RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
        Assert.assertEquals((double)8.0, (double)result.getState()[0].getReal(), (double)epsilon);
    }

    @Test
    public abstract void testDerivativesConsistency();

    protected <T extends RealFieldElement<T>> void doTestDerivativesConsistency(Field<T> field, double epsilon) {
        TestFieldProblem3<T> pb = new TestFieldProblem3<T>(field);
        RealFieldElement step = (RealFieldElement)((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).multiply(0.001);
        RungeKuttaFieldIntegrator<RealFieldElement> integ = this.createIntegrator(field, step);
        StepInterpolatorTestUtils.checkDerivativesConsistency(integ, pb, 1.0E-10);
    }

    @Test
    public abstract void testPartialDerivatives();

    protected void doTestPartialDerivatives(double epsilonY, double[] epsilonPartials) {
        int parameters = 5;
        boolean order = true;
        boolean parOmega = false;
        boolean parTO = true;
        int parY00 = 2;
        int parY01 = 3;
        int parT = 4;
        DerivativeStructure omega = new DerivativeStructure(5, 1, 0, 1.3);
        DerivativeStructure t0 = new DerivativeStructure(5, 1, 1, 1.3);
        DerivativeStructure[] y0 = new DerivativeStructure[]{new DerivativeStructure(5, 1, 2, 3.0), new DerivativeStructure(5, 1, 3, 4.0)};
        DerivativeStructure t = new DerivativeStructure(5, 1, 4, 6.0);
        SinCos sinCos = new SinCos(omega);
        RungeKuttaFieldIntegrator<DerivativeStructure> integrator = this.createIntegrator(omega.getField(), t.subtract(t0).multiply(0.001));
        FieldODEStateAndDerivative result = integrator.integrate(new FieldExpandableODE((FirstOrderFieldDifferentialEquations)sinCos), new FieldODEState((RealFieldElement)t0, (RealFieldElement[])y0), (RealFieldElement)t);
        for (int i = 0; i < sinCos.getDimension(); ++i) {
            Assert.assertEquals((double)sinCos.theoreticalY(t.getReal())[i], (double)((DerivativeStructure[])result.getState())[i].getValue(), (double)epsilonY);
        }
        double[][] derivatives = sinCos.getDerivatives(t.getReal());
        for (int i = 0; i < sinCos.getDimension(); ++i) {
            for (int parameter = 0; parameter < 5; ++parameter) {
                Assert.assertEquals((double)derivatives[i][parameter], (double)this.dYdP(((DerivativeStructure[])result.getState())[i], parameter), (double)epsilonPartials[parameter]);
            }
        }
    }

    private double dYdP(DerivativeStructure y, int parameter) {
        int[] orders = new int[y.getFreeParameters()];
        orders[parameter] = 1;
        return y.getPartialDerivative(orders);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SinCos
    implements FirstOrderFieldDifferentialEquations<DerivativeStructure> {
        private final DerivativeStructure omega;
        private DerivativeStructure r;
        private DerivativeStructure alpha;
        private double dRdY00;
        private double dRdY01;
        private double dAlphadOmega;
        private double dAlphadT0;
        private double dAlphadY00;
        private double dAlphadY01;

        protected SinCos(DerivativeStructure omega) {
            this.omega = omega;
        }

        public int getDimension() {
            return 2;
        }

        public void init(DerivativeStructure t0, DerivativeStructure[] y0, DerivativeStructure finalTime) {
            DerivativeStructure r2 = y0[0].multiply(y0[0]).add(y0[1].multiply(y0[1]));
            this.r = r2.sqrt();
            this.dRdY00 = y0[0].divide(this.r).getReal();
            this.dRdY01 = y0[1].divide(this.r).getReal();
            this.alpha = y0[0].atan2(y0[1]).subtract(t0.multiply(this.omega));
            this.dAlphadOmega = -t0.getReal();
            this.dAlphadT0 = -this.omega.getReal();
            this.dAlphadY00 = y0[1].divide(r2).getReal();
            this.dAlphadY01 = y0[0].negate().divide(r2).getReal();
        }

        public DerivativeStructure[] computeDerivatives(DerivativeStructure t, DerivativeStructure[] y) {
            return new DerivativeStructure[]{this.omega.multiply(y[1]), this.omega.multiply(y[0]).negate()};
        }

        public double[] theoreticalY(double t) {
            double theta = this.omega.getReal() * t + this.alpha.getReal();
            return new double[]{this.r.getReal() * FastMath.sin((double)theta), this.r.getReal() * FastMath.cos((double)theta)};
        }

        public double[][] getDerivatives(double t) {
            double theta = this.omega.getReal() * t + this.alpha.getReal();
            double sin = FastMath.sin((double)theta);
            double cos = FastMath.cos((double)theta);
            double y0 = this.r.getReal() * sin;
            double y1 = this.r.getReal() * cos;
            double dY0dOmega = y1 * (t + this.dAlphadOmega);
            double dY0dT0 = y1 * this.dAlphadT0;
            double dY0dY00 = this.dRdY00 * sin + y1 * this.dAlphadY00;
            double dY0dY01 = this.dRdY01 * sin + y1 * this.dAlphadY01;
            double dY0dT = y1 * this.omega.getReal();
            double dY1dOmega = -y0 * (t + this.dAlphadOmega);
            double dY1dT0 = -y0 * this.dAlphadT0;
            double dY1dY00 = this.dRdY00 * cos - y0 * this.dAlphadY00;
            double dY1dY01 = this.dRdY01 * cos - y0 * this.dAlphadY01;
            double dY1dT = -y0 * this.omega.getReal();
            return new double[][]{{dY0dOmega, dY0dT0, dY0dY00, dY0dY01, dY0dT}, {dY1dOmega, dY1dT0, dY1dY00, dY1dY01, dY1dT}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeplerHandler<T extends RealFieldElement<T>>
    implements FieldStepHandler<T> {
        private T maxError;
        private final TestFieldProblem3<T> pb;
        private final double expectedMaxError;
        private final double epsilon;

        public KeplerHandler(TestFieldProblem3<T> pb, double expectedMaxError, double epsilon) {
            this.pb = pb;
            this.expectedMaxError = expectedMaxError;
            this.epsilon = epsilon;
            this.maxError = (RealFieldElement)pb.getField().getZero();
        }

        public void init(FieldODEStateAndDerivative<T> state0, T t) {
            this.maxError = (RealFieldElement)this.pb.getField().getZero();
        }

        public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) throws MaxCountExceededException {
            FieldODEStateAndDerivative current = interpolator.getCurrentState();
            RealFieldElement[] theoreticalY = this.pb.computeTheoreticalState(current.getTime());
            RealFieldElement dx = (RealFieldElement)current.getState()[0].subtract((Object)theoreticalY[0]);
            RealFieldElement dy = (RealFieldElement)current.getState()[1].subtract((Object)theoreticalY[1]);
            RealFieldElement error = (RealFieldElement)((RealFieldElement)dx.multiply((Object)dx)).add(dy.multiply((Object)dy));
            if (((RealFieldElement)error.subtract(this.maxError)).getReal() > 0.0) {
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertEquals((double)this.expectedMaxError, (double)this.maxError.getReal(), (double)this.epsilon);
            }
        }
    }
}

