/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.LutherFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegratorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LutherFieldIntegratorTest
extends RungeKuttaFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> RungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, T step) {
        return new LutherFieldIntegrator(field, step);
    }

    @Override
    public void testNonFieldIntegratorConsistency() {
        this.doTestNonFieldIntegratorConsistency(Decimal64Field.getInstance());
    }

    @Override
    public void testMissedEndEvent() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestMissedEndEvent(Decimal64Field.getInstance(), 1.0E-15, 1.0E-15);
    }

    @Override
    public void testSanityChecks() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestSanityChecks(Decimal64Field.getInstance());
    }

    @Override
    public void testDecreasingSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestDecreasingSteps(Decimal64Field.getInstance(), 1.0, 1.0, 1.0E-10);
    }

    @Override
    public void testSmallStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestSmallStep(Decimal64Field.getInstance(), 8.7E-17, 3.6E-15, 1.0E-12, "Luther");
    }

    @Override
    public void testBigStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestBigStep(Decimal64Field.getInstance(), 2.7E-5, 0.0017, 1.0E-12, "Luther");
    }

    @Override
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestBackward(Decimal64Field.getInstance(), 2.4E-13, 4.3E-13, 1.0E-12, "Luther");
    }

    @Override
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestKepler(Decimal64Field.getInstance(), 2.18E-7, 4.0E-10);
    }

    @Override
    public void testStepSize() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.doTestStepSize(Decimal64Field.getInstance(), 1.0E-22);
    }

    @Override
    public void testSingleStep() {
        this.doTestSingleStep(Decimal64Field.getInstance(), 6.0E-12);
    }

    @Override
    public void testTooLargeFirstStep() {
        this.doTestTooLargeFirstStep(Decimal64Field.getInstance());
    }

    @Override
    public void testUnstableDerivative() {
        this.doTestUnstableDerivative(Decimal64Field.getInstance(), 4.0E-15);
    }

    @Override
    public void testDerivativesConsistency() {
        this.doTestDerivativesConsistency(Decimal64Field.getInstance(), 1.0E-20);
    }

    @Override
    public void testPartialDerivatives() {
        this.doTestPartialDerivatives(4.3E-13, new double[]{2.2E-12, 5.6E-13, 9.4E-14, 9.4E-14, 5.6E-13});
    }
}

