/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldExpandableODE;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEState;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldSecondaryEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.util.Decimal64Field;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldExpandableODETest {
    @Test
    public void testOnlyMainEquation() {
        this.doTestOnlyMainEquation((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestOnlyMainEquation(Field<T> field) {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Assert.assertEquals((long)main.getDimension(), (long)equation.getMapper().getTotalDimension());
        Assert.assertEquals((long)1L, (long)equation.getMapper().getNumberOfEquations());
        RealFieldElement t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(10.0);
        RealFieldElement t = (RealFieldElement)((RealFieldElement)field.getZero()).add(100.0);
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        for (int i = 0; i < complete.length; ++i) {
            complete[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add((double)i);
        }
        equation.init(t0, complete, t);
        RealFieldElement[] completeDot = equation.computeDerivatives(t0, complete);
        FieldODEStateAndDerivative state = equation.getMapper().mapStateAndDerivative(t0, complete, completeDot);
        Assert.assertEquals((long)0L, (long)state.getNumberOfSecondaryStates());
        RealFieldElement[] mainState = state.getState();
        RealFieldElement[] mainStateDot = state.getDerivative();
        Assert.assertEquals((long)main.getDimension(), (long)mainState.length);
        for (int i = 0; i < main.getDimension(); ++i) {
            Assert.assertEquals((double)i, (double)mainState[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)mainStateDot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)completeDot[i].getReal(), (double)1.0E-15);
        }
    }

    @Test
    public void testMainAndSecondary() {
        this.doTestMainAndSecondary((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestMainAndSecondary(Field<T> field) {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Linear secondary1 = new Linear(field, 3, main.getDimension());
        int i1 = equation.addSecondaryEquations(secondary1);
        Linear secondary2 = new Linear(field, 5, main.getDimension() + secondary1.getDimension());
        int i2 = equation.addSecondaryEquations(secondary2);
        Assert.assertEquals((long)(main.getDimension() + secondary1.getDimension() + secondary2.getDimension()), (long)equation.getMapper().getTotalDimension());
        Assert.assertEquals((long)3L, (long)equation.getMapper().getNumberOfEquations());
        Assert.assertEquals((long)1L, (long)i1);
        Assert.assertEquals((long)2L, (long)i2);
        RealFieldElement t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(10.0);
        RealFieldElement t = (RealFieldElement)((RealFieldElement)field.getZero()).add(100.0);
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        for (int i = 0; i < complete.length; ++i) {
            complete[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add((double)i);
        }
        equation.init(t0, complete, t);
        RealFieldElement[] completeDot = equation.computeDerivatives(t0, complete);
        RealFieldElement[] mainState = equation.getMapper().extractEquationData(0, complete);
        RealFieldElement[] mainStateDot = equation.getMapper().extractEquationData(0, completeDot);
        Assert.assertEquals((long)main.getDimension(), (long)mainState.length);
        for (int i = 0; i < main.getDimension(); ++i) {
            Assert.assertEquals((double)i, (double)mainState[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)mainStateDot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)completeDot[i].getReal(), (double)1.0E-15);
        }
        RealFieldElement[] secondaryState1 = equation.getMapper().extractEquationData(i1, complete);
        RealFieldElement[] secondaryState1Dot = equation.getMapper().extractEquationData(i1, completeDot);
        Assert.assertEquals((long)secondary1.getDimension(), (long)secondaryState1.length);
        for (int i = 0; i < secondary1.getDimension(); ++i) {
            Assert.assertEquals((double)(i + main.getDimension()), (double)secondaryState1[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)secondaryState1Dot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)completeDot[i + main.getDimension()].getReal(), (double)1.0E-15);
        }
        RealFieldElement[] secondaryState2 = equation.getMapper().extractEquationData(i2, complete);
        RealFieldElement[] secondaryState2Dot = equation.getMapper().extractEquationData(i2, completeDot);
        Assert.assertEquals((long)secondary2.getDimension(), (long)secondaryState2.length);
        for (int i = 0; i < secondary2.getDimension(); ++i) {
            Assert.assertEquals((double)(i + main.getDimension() + secondary1.getDimension()), (double)secondaryState2[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)secondaryState2Dot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)completeDot[i + main.getDimension() + secondary1.getDimension()].getReal(), (double)1.0E-15);
        }
    }

    @Test
    public void testMap() {
        this.doTestMap((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestMap(Field<T> field) {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Linear secondary1 = new Linear(field, 3, main.getDimension());
        int i1 = equation.addSecondaryEquations(secondary1);
        Linear secondary2 = new Linear(field, 5, main.getDimension() + secondary1.getDimension());
        int i2 = equation.addSecondaryEquations(secondary2);
        Assert.assertEquals((long)(main.getDimension() + secondary1.getDimension() + secondary2.getDimension()), (long)equation.getMapper().getTotalDimension());
        Assert.assertEquals((long)3L, (long)equation.getMapper().getNumberOfEquations());
        Assert.assertEquals((long)1L, (long)i1);
        Assert.assertEquals((long)2L, (long)i2);
        RealFieldElement t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(10.0);
        RealFieldElement t = (RealFieldElement)((RealFieldElement)field.getZero()).add(100.0);
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        for (int i = 0; i < complete.length; ++i) {
            complete[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add((double)i);
        }
        equation.init(t0, complete, t);
        RealFieldElement[] completeDot = equation.computeDerivatives(t0, complete);
        try {
            equation.getMapper().mapStateAndDerivative(t0, (RealFieldElement[])MathArrays.buildArray(field, (int)(complete.length + 1)), completeDot);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            equation.getMapper().mapStateAndDerivative(t0, complete, (RealFieldElement[])MathArrays.buildArray(field, (int)(completeDot.length + 1)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        FieldODEStateAndDerivative state = equation.getMapper().mapStateAndDerivative(t0, complete, completeDot);
        Assert.assertEquals((long)2L, (long)state.getNumberOfSecondaryStates());
        Assert.assertEquals((long)main.getDimension(), (long)state.getSecondaryStateDimension(0));
        Assert.assertEquals((long)secondary1.getDimension(), (long)state.getSecondaryStateDimension(i1));
        Assert.assertEquals((long)secondary2.getDimension(), (long)state.getSecondaryStateDimension(i2));
        RealFieldElement[] mainState = state.getState();
        RealFieldElement[] mainStateDot = state.getDerivative();
        RealFieldElement[] mainStateAlternate = state.getSecondaryState(0);
        RealFieldElement[] mainStateDotAlternate = state.getSecondaryDerivative(0);
        Assert.assertEquals((long)main.getDimension(), (long)mainState.length);
        for (int i = 0; i < main.getDimension(); ++i) {
            Assert.assertEquals((double)i, (double)mainState[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)mainStateDot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)mainStateAlternate[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)mainStateDotAlternate[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)i, (double)completeDot[i].getReal(), (double)1.0E-15);
        }
        RealFieldElement[] secondaryState1 = state.getSecondaryState(i1);
        RealFieldElement[] secondaryState1Dot = state.getSecondaryDerivative(i1);
        Assert.assertEquals((long)secondary1.getDimension(), (long)secondaryState1.length);
        for (int i = 0; i < secondary1.getDimension(); ++i) {
            Assert.assertEquals((double)(i + main.getDimension()), (double)secondaryState1[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)secondaryState1Dot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)completeDot[i + main.getDimension()].getReal(), (double)1.0E-15);
        }
        RealFieldElement[] secondaryState2 = state.getSecondaryState(i2);
        RealFieldElement[] secondaryState2Dot = state.getSecondaryDerivative(i2);
        Assert.assertEquals((long)secondary2.getDimension(), (long)secondaryState2.length);
        for (int i = 0; i < secondary2.getDimension(); ++i) {
            Assert.assertEquals((double)(i + main.getDimension() + secondary1.getDimension()), (double)secondaryState2[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)secondaryState2Dot[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)(-i), (double)completeDot[i + main.getDimension() + secondary1.getDimension()].getReal(), (double)1.0E-15);
        }
        RealFieldElement[] remappedState = equation.getMapper().mapState((FieldODEState)state);
        RealFieldElement[] remappedDerivative = equation.getMapper().mapDerivative(state);
        Assert.assertEquals((long)equation.getMapper().getTotalDimension(), (long)remappedState.length);
        Assert.assertEquals((long)equation.getMapper().getTotalDimension(), (long)remappedDerivative.length);
        for (int i = 0; i < remappedState.length; ++i) {
            Assert.assertEquals((double)complete[i].getReal(), (double)remappedState[i].getReal(), (double)1.0E-15);
            Assert.assertEquals((double)completeDot[i].getReal(), (double)remappedDerivative[i].getReal(), (double)1.0E-15);
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testExtractDimensionMismatch() {
        this.doTestExtractDimensionMismatch((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestExtractDimensionMismatch(Field<T> field) throws DimensionMismatchException {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Linear secondary1 = new Linear(field, 3, main.getDimension());
        int i1 = equation.addSecondaryEquations(secondary1);
        RealFieldElement[] tooShort = (RealFieldElement[])MathArrays.buildArray(field, (int)main.getDimension());
        equation.getMapper().extractEquationData(i1, tooShort);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testInsertTooShortComplete() {
        this.doTestInsertTooShortComplete((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestInsertTooShortComplete(Field<T> field) throws DimensionMismatchException {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Linear secondary1 = new Linear(field, 3, main.getDimension());
        int i1 = equation.addSecondaryEquations(secondary1);
        RealFieldElement[] equationData = (RealFieldElement[])MathArrays.buildArray(field, (int)secondary1.getDimension());
        RealFieldElement[] tooShort = (RealFieldElement[])MathArrays.buildArray(field, (int)main.getDimension());
        equation.getMapper().insertEquationData(i1, equationData, tooShort);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testInsertWrongEquationData() {
        this.doTestInsertWrongEquationData((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestInsertWrongEquationData(Field<T> field) throws DimensionMismatchException {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        Linear secondary1 = new Linear(field, 3, main.getDimension());
        int i1 = equation.addSecondaryEquations(secondary1);
        RealFieldElement[] wrongEquationData = (RealFieldElement[])MathArrays.buildArray(field, (int)(secondary1.getDimension() + 1));
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        equation.getMapper().insertEquationData(i1, wrongEquationData, complete);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNegativeIndex() {
        this.doTestNegativeIndex((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestNegativeIndex(Field<T> field) throws MathIllegalArgumentException {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        equation.getMapper().extractEquationData(-1, complete);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testTooLargeIndex() {
        this.doTestTooLargeIndex((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestTooLargeIndex(Field<T> field) throws MathIllegalArgumentException {
        Linear main = new Linear(field, 3, 0);
        FieldExpandableODE equation = new FieldExpandableODE(main);
        RealFieldElement[] complete = (RealFieldElement[])MathArrays.buildArray(field, (int)equation.getMapper().getTotalDimension());
        equation.getMapper().extractEquationData(1, complete);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Linear<T extends RealFieldElement<T>>
    implements FirstOrderFieldDifferentialEquations<T>,
    FieldSecondaryEquations<T> {
        private final Field<T> field;
        private final int dimension;
        private final int start;

        private Linear(Field<T> field, int dimension, int start) {
            this.field = field;
            this.dimension = dimension;
            this.start = start;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void init(T t0, T[] y0, T finalTime) {
            Assert.assertEquals((long)this.dimension, (long)y0.length);
            Assert.assertEquals((double)10.0, (double)t0.getReal(), (double)1.0E-15);
            Assert.assertEquals((double)100.0, (double)finalTime.getReal(), (double)1.0E-15);
            for (int i = 0; i < y0.length; ++i) {
                Assert.assertEquals((double)i, (double)y0[i].getReal(), (double)1.0E-15);
            }
        }

        public T[] computeDerivatives(T t, T[] y) {
            RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.field, (int)this.dimension);
            for (int i = 0; i < this.dimension; ++i) {
                yDot[i] = (RealFieldElement)((RealFieldElement)this.field.getZero()).add((double)i);
            }
            return yDot;
        }

        public void init(T t0, T[] primary0, T[] secondary0, T finalTime) {
            int i;
            Assert.assertEquals((long)this.dimension, (long)secondary0.length);
            Assert.assertEquals((double)10.0, (double)t0.getReal(), (double)1.0E-15);
            Assert.assertEquals((double)100.0, (double)finalTime.getReal(), (double)1.0E-15);
            for (i = 0; i < primary0.length; ++i) {
                Assert.assertEquals((double)i, (double)primary0[i].getReal(), (double)1.0E-15);
            }
            for (i = 0; i < secondary0.length; ++i) {
                Assert.assertEquals((double)(this.start + i), (double)secondary0[i].getReal(), (double)1.0E-15);
            }
        }

        public T[] computeDerivatives(T t, T[] primary, T[] primaryDot, T[] secondary) {
            RealFieldElement[] secondaryDot = (RealFieldElement[])MathArrays.buildArray(this.field, (int)this.dimension);
            for (int i = 0; i < this.dimension; ++i) {
                secondaryDot[i] = (RealFieldElement)((RealFieldElement)this.field.getZero()).subtract((double)i);
            }
            return secondaryDot;
        }
    }
}

