/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;
import org.junit.Assert;
import org.junit.Test;

public class QuasiSigmoidDecayFunctionTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition1() {
        new QuasiSigmoidDecayFunction(0.0, -1.0, 2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPrecondition3() {
        new QuasiSigmoidDecayFunction(1.0, 0.0, 100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition4() {
        new QuasiSigmoidDecayFunction(1.0, -1.0, 0L);
    }

    @Test
    public void testTrivial() {
        int n = 65;
        double init = 4.0;
        double slope = -0.1;
        QuasiSigmoidDecayFunction f = new QuasiSigmoidDecayFunction(4.0, -0.1, 65L);
        Assert.assertEquals((double)4.0, (double)f.value(0L), (double)0.0);
        Assert.assertEquals((double)-0.1, (double)(f.value(66L) - f.value(65L)), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)f.value(Long.MAX_VALUE), (double)0.0);
    }
}

